% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolators.R
\name{quintic_hermite}
\alias{quintic_hermite}
\title{Quintic Hermite Interpolator}
\usage{
quintic_hermite(x, y, dydx, d2ydx2)
}
\arguments{
\item{x}{Numeric vector of abscissas (x-coordinates).}

\item{y}{Numeric vector of ordinates (y-coordinates).}

\item{dydx}{Numeric vector of first derivatives (slopes) at each point.}

\item{d2ydx2}{Numeric vector of second derivatives at each point.}
}
\value{
An object of class \code{quintic_hermite} with methods:
\itemize{
\item \code{interpolate(xi)}: Evaluate the interpolator at point \code{xi}.
\item \code{prime(xi)}: Evaluate the derivative of the interpolator at point \code{xi}.
\item \code{double_prime(xi)}: Evaluate the second derivative of the interpolator at point \code{xi}.
\item \code{push_back(x, y, dydx, d2ydx2)}: Add a new control point to the interpolator.
\item \code{domain()}: Get the domain of the interpolator.
}
}
\description{
Constructs a quintic Hermite interpolator given the vectors of abscissas, ordinates, first derivatives, and second derivatives.
}
\examples{
x <- c(0, 1, 2)
y <- c(0, 1, 0)
dydx <- c(1, 0, -1)
d2ydx2 <- c(0, -1, 0)
interpolator <- quintic_hermite(x, y, dydx, d2ydx2)
xi <- 0.5
interpolator$interpolate(xi)
interpolator$prime(xi)
interpolator$double_prime(xi)
interpolator$push_back(3, 0, 1, 0)
interpolator$domain()
}
