% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plugin-stack.R
\name{edit_stack}
\alias{edit_stack}
\alias{edit_stack_server}
\alias{edit_stack_ui}
\title{Plugin module for editing board stacks}
\usage{
edit_stack(server = edit_stack_server, ui = edit_stack_ui)

edit_stack_server(id, stack_id, board, update, ...)

edit_stack_ui(id, x, ...)
}
\arguments{
\item{server, ui}{Server/UI for the plugin module}

\item{id}{Namespace ID}

\item{stack_id}{Stack ID}

\item{board}{Reactive values object containing board information}

\item{update}{Reactive value object to initiate board updates}

\item{...}{Extra arguments passed from parent scope}

\item{x}{Stack}
}
\value{
A plugin container inheriting from \code{edit_stack} is returned by
\code{edit_stack()}, while the UI component (e.g. \code{edit_stack_ui()}) is
expected to return shiny UI (i.e. \code{\link[shiny:reexports]{shiny::tagList()}}) and the server
component (i.e. \code{edit_stack_server()}) is expected to return \code{NULL}.
}
\description{
Logic and user experience for editing stack attributes such as stack names
can be customized or enhanced by providing an alternate version of this
plugin. The default implementation only handles stack names, but if further
(editable) stack attributes are to be introduced, corresponding UI and logic
can be included here. In addition to stack names, this default
implementation provides UI for removing the current stack.
}
