% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_MakeFormula.R
\name{bm_MakeFormula}
\alias{bm_MakeFormula}
\title{Standardized formula maker}
\usage{
bm_MakeFormula(
  resp.name,
  expl.var,
  type = "simple",
  interaction.level = 0,
  k = NULL
)
}
\arguments{
\item{resp.name}{a \code{character} corresponding to the response variable name}

\item{expl.var}{a \code{matrix} or \code{data.frame} containing the explanatory variables that 
will be used at the modeling step}

\item{type}{a \code{character} corresponding to the wanted type of formula, must be 
\code{simple}, \code{quadratic}, \code{polynomial} or \code{s_smoother}}

\item{interaction.level}{an \code{integer} corresponding to the interaction level depth 
between explanatory variables}

\item{k}{(\emph{optional, default} \code{NULL}) \cr 
An \code{integer} corresponding to the smoothing parameter value of \code{\link[mgcv]{s}} 
or \code{\link[gam]{s}} arguments (\emph{used only if \code{type = 's_smoother'}})}
}
\value{
A \code{\link[stats]{formula}} class object that can be directly given to most of 
\R statistical models.
}
\description{
This internal \pkg{biomod2} function allows the user to create easily a 
standardized formula that can be used later by statistical models.
}
\details{
It is advised to give only a subset of \code{expl.var} table to avoid useless memory consuming. 
\cr If some explanatory variables are factorial, \code{expl.var} must be a \code{data.frame} 
whose corresponding columns are defined as \code{factor}.
}
\examples{

## Create simple simulated data
myResp.s <- sample(c(0, 1), 20, replace = TRUE)
myExpl.s <- data.frame(var1 = sample(c(0, 1), 100, replace = TRUE),
                       var2 = rnorm(100),
                       var3 = 1:100)

## Generate automatic formula
bm_MakeFormula(resp.name = 'myResp.s',
               expl.var = head(myExpl.s),
               type = 'quadratic',
               interaction.level = 0)


}
\seealso{
\code{\link[stats]{formula}}, \code{\link[mgcv]{s}}, \code{\link[gam]{s}}, 
\code{\link{bm_ModelingOptions}}, \code{\link{bm_Tuning}}, 
\code{\link{bm_RunModelsLoop}}

Other Secondary functions: 
\code{\link{bm_BinaryTransformation}()},
\code{\link{bm_CrossValidation}()},
\code{\link{bm_FindOptimStat}()},
\code{\link{bm_ModelingOptions}()},
\code{\link{bm_PlotEvalBoxplot}()},
\code{\link{bm_PlotEvalMean}()},
\code{\link{bm_PlotRangeSize}()},
\code{\link{bm_PlotResponseCurves}()},
\code{\link{bm_PlotVarImpBoxplot}()},
\code{\link{bm_PseudoAbsences}()},
\code{\link{bm_RunModelsLoop}()},
\code{\link{bm_SRE}()},
\code{\link{bm_SampleBinaryVector}()},
\code{\link{bm_SampleFactorLevels}()},
\code{\link{bm_Tuning}()},
\code{\link{bm_VariablesImportance}()}
}
\author{
Damien Georges
}
\concept{Secondary functions}
\keyword{formula}
\keyword{models}
\keyword{options}
