% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coxsgplsDR.R
\name{coxsgplsDR}
\alias{coxsgplsDR}
\alias{coxsgplsDR.default}
\alias{coxsgplsDR.formula}
\title{Fitting a Cox-Model on group sparse PLSR components using the (Deviance) Residuals}
\usage{
coxsgplsDR(Xplan, ...)

\method{coxsgplsDR}{formula}(
  Xplan,
  time,
  time2,
  event,
  type,
  origin,
  typeres = "deviance",
  collapse,
  weighted,
  scaleX = TRUE,
  scaleY = TRUE,
  ncomp = min(7, ncol(Xplan)),
  modepls = "regression",
  ind.block.x,
  keepX,
  alpha.x,
  upper.lambda = 10^5,
  plot = FALSE,
  allres = FALSE,
  dataXplan = NULL,
  subset,
  weights,
  model_frame = FALSE,
  model_matrix = FALSE,
  contrasts.arg = NULL,
  ...
)

\method{coxsgplsDR}{default}(
  Xplan,
  time,
  time2,
  event,
  type,
  origin,
  typeres = "deviance",
  collapse,
  weighted,
  scaleX = TRUE,
  scaleY = TRUE,
  ncomp = min(7, ncol(Xplan)),
  modepls = "regression",
  ind.block.x,
  keepX,
  alpha.x,
  upper.lambda = 10^5,
  plot = FALSE,
  allres = FALSE,
  ...
)
}
\arguments{
\item{Xplan}{a formula or a matrix with the eXplanatory variables (training)
dataset}

\item{\dots}{Arguments to be passed on to \code{survival::coxph}.}

\item{time}{for right censored data, this is the follow up time. For
interval data, the first argument is the starting time for the interval.}

\item{time2}{The status indicator, normally 0=alive, 1=dead. Other choices
are \code{TRUE/FALSE} (\code{TRUE} = death) or 1/2 (2=death). For interval
censored data, the status indicator is 0=right censored, 1=event at
\code{time}, 2=left censored, 3=interval censored. Although unusual, the
event indicator can be omitted, in which case all subjects are assumed to
have an event.}

\item{event}{ending time of the interval for interval censored or counting
process data only. Intervals are assumed to be open on the left and closed
on the right, \code{(start, end]}. For counting process data, event
indicates whether an event occurred at the end of the interval.}

\item{type}{character string specifying the type of censoring. Possible
values are \code{"right"}, \code{"left"}, \code{"counting"},
\code{"interval"}, or \code{"interval2"}. The default is \code{"right"} or
\code{"counting"} depending on whether the \code{time2} argument is absent
or present, respectively.}

\item{origin}{for counting process data, the hazard function origin. This
option was intended to be used in conjunction with a model containing time
dependent strata in order to align the subjects properly when they cross
over from one strata to another, but it has rarely proven useful.}

\item{typeres}{character string indicating the type of residual desired.
Possible values are \code{"martingale"}, \code{"deviance"}, \code{"score"},
\code{"schoenfeld"}, \code{"dfbeta"}, \code{"dfbetas"}, and
\code{"scaledsch"}. Only enough of the string to determine a unique match is
required.}

\item{collapse}{vector indicating which rows to collapse (sum) over. In
time-dependent models more than one row data can pertain to a single
individual. If there were 4 individuals represented by 3, 1, 2 and 4 rows of
data respectively, then \code{collapse=c(1,1,1,2,3,3,4,4,4,4)} could be used
to obtain per subject rather than per observation residuals.}

\item{weighted}{if \code{TRUE} and the model was fit with case weights, then
the weighted residuals are returned.}

\item{scaleX}{Should the \code{Xplan} columns be standardized ?}

\item{scaleY}{Should the \code{time} values be standardized ?}

\item{ncomp}{The number of components to include in the model. It this is
not supplied, min(7,maximal number) components is used.}

\item{modepls}{character string. What type of algorithm to use, (partially)
matching one of "regression", "canonical". See
\code{\link[sgPLS]{gPLS}} for details}

\item{ind.block.x}{a vector of integers describing the grouping of the
X-variables. \code{ind.block.x <- c(3,10,15)} means that \code{X} is
structured into 4 groups: \code{X1} to \code{X3}; \code{X4} to \code{X10},
\code{X11} to \code{X15} and \code{X16} to \code{Xp} where \code{p} is the
number of variables in the X matrix.}

\item{keepX}{numeric vector of length ncomp, the number of variables to keep
in X-loadings. By default all variables are kept in the model.}

\item{alpha.x}{The mixing parameter (value between 0 and 1) related to the sparsity
within group for the X dataset.}

\item{upper.lambda}{By default \code{upper.lambda=10^5}. A large value
specifying the upper bound of the intervall of lambda values for searching
the value of the tuning parameter (lambda) corresponding to a non-zero group
of variables.}

\item{plot}{Should the survival function be plotted ?)}

\item{allres}{FALSE to return only the Cox model and TRUE for additionnal
results. See details. Defaults to FALSE.}

\item{dataXplan}{an optional data frame, list or environment (or object
coercible by \code{\link{as.data.frame}} to a data frame) containing the
variables in the model. If not found in \code{dataXplan}, the variables are
taken from \code{environment(Xplan)}, typically the environment from which
\code{coxpls} is called.}

\item{subset}{an optional vector specifying a subset of observations to be
used in the fitting process.}

\item{weights}{an optional vector of 'prior weights' to be used in the
fitting process. Should be \code{NULL} or a numeric vector.}

\item{model_frame}{If \code{TRUE}, the model frame is returned.}

\item{model_matrix}{If \code{TRUE}, the model matrix is returned.}

\item{contrasts.arg}{a list, whose entries are values (numeric matrices,
functions or character strings naming functions) to be used as replacement
values for the contrasts replacement function and whose names are the names
of columns of data containing factors.}
}
\value{
If \code{allres=FALSE} : \item{cox_sgplsDR}{Final Cox-model.} If
\code{allres=TRUE} : \item{tt_sgplsDR}{PLSR components.} \item{cox_sgplsDR}{Final
Cox-model.} \item{sgplsDR_mod}{The PLSR model.}
}
\description{
This function computes the Cox Model based on PLSR components computed model
with \itemize{\item as the response: the Survival time \item as explanatory
variables: Xplan.  } It uses the package \code{sgplsDR} to perform group PLSR
fit.
}
\details{
If \code{allres=FALSE} returns only the final Cox-model. If
\code{allres=TRUE} returns a list with the PLS components, the final
Cox-model and the group PLSR model. \code{allres=TRUE} is useful for evluating
model prediction accuracy on a test sample.
}
\examples{

data(micro.censure)
data(Xmicro.censure_compl_imp)

X_train_micro <- apply((as.matrix(Xmicro.censure_compl_imp)),FUN="as.numeric",MARGIN=2)[1:80,]
X_train_micro_df <- data.frame(X_train_micro)
Y_train_micro <- micro.censure$survyear[1:80]
C_train_micro <- micro.censure$DC[1:80]

(coxsgplsDR_fit=coxsgplsDR(X_train_micro,Y_train_micro,C_train_micro,
ncomp=6,ind.block.x=c(3,10,15), alpha.x = rep(0.95, 6)))
(coxsgplsDR_fit=coxsgplsDR(~X_train_micro,Y_train_micro,C_train_micro,
ncomp=6,ind.block.x=c(3,10,15), alpha.x = rep(0.95, 6)))
(coxsgplsDR_fit=coxsgplsDR(~.,Y_train_micro,C_train_micro,ncomp=6,
dataXplan=X_train_micro_df,ind.block.x=c(3,10,15), alpha.x = rep(0.95, 6)))

rm(X_train_micro,Y_train_micro,C_train_micro,cox_sgplsDR_sgfit)

}
\references{
A group and Sparse Group Partial Least Square approach applied
in Genomics context, Liquet Benoit, Lafaye de Micheaux, Boris Hejblum,
Rodolphe Thiebaut (2016). Bioinformatics.\cr

Deviance residuals-based sparse PLS and sparse kernel PLS regression for
censored data, Philippe Bastien, Frederic Bertrand, Nicolas Meyer and Myriam
Maumy-Bertrand (2015), Bioinformatics, 31(3):397-404,
doi:10.1093/bioinformatics/btu660.
}
\seealso{
\code{\link[survival]{coxph}}, \code{\link[sgPLS]{gPLS}}
}
\author{
Frédéric Bertrand\cr
\email{frederic.bertrand@lecnam.net}\cr
\url{https://fbertran.github.io/homepage/}
}
\keyword{models}
\keyword{regression}
