% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/big_pls_cox.R.R
\name{big_pls_cox}
\alias{big_pls_cox}
\title{Partial Least Squares Components for Cox Models with Big Matrices}
\usage{
big_pls_cox(
  X,
  time,
  status,
  ncomp = 2L,
  control = survival::coxph.control(),
  keepX = NULL
)
}
\arguments{
\item{X}{A numeric matrix or a \code{\link[bigmemory:big.matrix]{bigmemory::big.matrix}} object containing the predictors.}

\item{time}{Numeric vector of survival times.}

\item{status}{Integer (0/1) vector of event indicators.}

\item{ncomp}{Number of latent components to compute.}

\item{control}{Optional list passed to \code{\link[survival:coxph.control]{survival::coxph.control}}.}

\item{keepX}{Optional integer vector specifying the number of variables to
retain (naive sparsity) in each component. A value of zero keeps all
predictors. If a single integer is supplied it is recycled across
components.}
}
\value{
A list with the computed scores, loadings, weights, scaling information and the
fitted Cox model returned by \code{\link[survival:agreg.fit]{survival::coxph.fit}}.
}
\description{
Compute Partial Least Squares (PLS) components tailored for
Cox proportional hazards models when predictors are stored as a
\code{big.matrix} from the \pkg{bigmemory} package.
}
\details{
The function standardises each predictor column, iteratively
builds latent scores using martingale residuals from Cox fits, and deflates
the predictors without materialising the full design matrix in memory.
Both in-memory and file-backed \pkg{bigmemory} matrices are supported.
}
\examples{
if (requireNamespace("survival", quietly = TRUE)) {
  set.seed(1)
  X <- matrix(rnorm(100), nrow = 20)
  time <- rexp(20)
  status <- rbinom(20, 1, 0.5)
  fit <- big_pls_cox(X, time, status, ncomp = 2)
  str(fit)
}

}
\references{
Maumy, M., Bertrand, F. (2023). PLS models and their extension for big data.
Joint Statistical Meetings (JSM 2023), Toronto, ON, Canada.

Maumy, M., Bertrand, F. (2023). bigPLS: Fitting and cross-validating
PLS-based Cox models to censored big data. BioC2023 — The Bioconductor
Annual Conference, Dana-Farber Cancer Institute, Boston, MA, USA.
Poster. https://doi.org/10.7490/f1000research.1119546.1

Bastien, P., Bertrand, F., Meyer, N., & Maumy-Bertrand, M. (2015).
Deviance residuals-based sparse PLS and sparse kernel PLS for censored
data. \emph{Bioinformatics}, 31(3), 397–404. \url{doi:10.1093/bioinformatics/btu660}

Bertrand, F., Bastien, P., Meyer, N., & Maumy-Bertrand, M. (2014). PLS
models for censored data. In \emph{Proceedings of UseR! 2014} (p. 152).
}
\seealso{
\code{\link[=big_pls_cox_gd]{big_pls_cox_gd()}}, \code{\link[=predict.big_pls_cox]{predict.big_pls_cox()}}, \code{\link[=select_ncomp]{select_ncomp()}},
\code{\link[=computeDR]{computeDR()}}.
}
