% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cell_mse.R
\name{cell_mse}
\alias{cell_mse}
\title{Make a data frame containing the MSE for each bicluster cell}
\usage{
cell_mse(x)
}
\arguments{
\item{x}{An object of class \code{biclustermd}.}
}
\value{
A data frame giving the row cluster, column cluster, the number of
data points in each row and column cluster, the number of data points missing
in the cell, and the cell MSE.
}
\description{
Make a data frame containing the MSE for each bicluster cell
}
\examples{
data("synthetic")
bc <- biclustermd(synthetic, col_clusters = 3, row_clusters = 2,
                miss_val = mean(synthetic, na.rm = TRUE),
                miss_val_sd = sd(synthetic, na.rm = TRUE),
                col_min_num = 2, row_min_num = 2,
                col_num_to_move = 1, row_num_to_move = 1,
                max.iter = 10)
cell_mse(bc)
}
