% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDA_gibbs_functions.R
\name{sample.z}
\alias{sample.z}
\title{Internal function to sample latent clusters}
\usage{
sample.z(ntsegm, nbins, y, nmaxclust, phi, ltheta, zeroes, ndata.types)
}
\arguments{
\item{ntsegm}{numeric. The total number of time segments from all animal IDs.}

\item{nbins}{numeric. A vector of the number of bins used to discretize each
movement variable. These must be in the same order as the columns within
\code{y}.}

\item{y}{A list where each element stores separate aggregated count data per
bin per time segment for each movement variable being analyzed. These are
stored as matrices.}

\item{nmaxclust}{numeric. A single number indicating the maximum number of
clusters to test.}

\item{phi}{A list where each element stores separate proportions per bin per
time segment for each movement variable.}

\item{ltheta}{A matrix storing the log-transformed values from the
\code{theta} parameter.}

\item{zeroes}{A list of arrays that contain only zero values which are three
dimensional (ntsegm,nbins[i],nmaxclust).}

\item{ndata.types}{numeric. The number of data streams being analyzed.}
}
\value{
A list with estimates for \emph{z} where the number of elements is equal to
  the number of movement variables.
}
\description{
This function samples the latent \emph{z} parameter within the Gibbs sampler.
Calls on the \code{SampleZAgg} function written in C++. Not for calling
directly by users.
}
