% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Explain_stats.R
\name{Explain_stats}
\alias{Explain_stats}
\alias{Explain_stats.default}
\alias{Explain_stats.Explainbarp}
\title{Numerical summary of Shapley values from an Explain object}
\usage{
Explain_stats(
  x,
  probs = 0.95,
  abs = TRUE,
  na.rm = TRUE,
  geo.unit = NULL,
  geo.id = NULL
)

\method{Explain_stats}{default}(
  x,
  probs = 0.95,
  abs = TRUE,
  na.rm = TRUE,
  geo.unit = NULL,
  geo.id = NULL
)

\method{Explain_stats}{Explainbarp}(
  x,
  probs = 0.95,
  abs = TRUE,
  na.rm = TRUE,
  geo.unit = NULL,
  geo.id = NULL
)
}
\arguments{
\item{x}{An object belonging to the \code{Explain} class or its subclasses, containing the Shapley values.}

\item{probs}{Enter the probability for the quantile interval. Default is \code{0.95}.}

\item{abs}{Logical. If \code{TRUE}, summarizes absolute Shapley values (importance-style).}

\item{na.rm}{Logical. Remove NA values in summaries. Default is \code{TRUE}.}

\item{geo.unit}{(Explainbarp only) Name of the stratification variable used in post-stratification.}

\item{geo.id}{(Explainbarp only) One value of interest among the values of the stratification variable.}
}
\value{
A named list with two elements:
\item{obs}{A data.frame containing observation-based numerical summaries of Shapley values for each variable.}
\item{post}{A data.frame containing posterior-sample-based numerical summaries of Shapley values for each variable.}
}
\description{
Computes global numerical summaries of Shapley values using two averaging criteria:
observation-based and posterior-sample-based.
}
\examples{
\donttest{
## Friedman data
set.seed(2025)
n <- 200
p <- 5
X <- data.frame(matrix(runif(n * p), ncol = p))
y <- 10 * sin(pi* X[ ,1] * X[,2]) +20 * (X[,3] -.5)^2 + 10 * X[ ,4] + 5 * X[,5] + rnorm(n)

## Using the dbarts library
model <- dbarts::bart(X,y,keeptrees = TRUE ,  ndpost = 200)

## prediction wrapper function
pfun <- function(object, newdata) {
       predict(object , newdata)
       }
       
## Calculate shapley values
model_exp <-  Explain  ( model, X = X,  pred_wrapper =  pfun )

# Numerical summaries of summarised Shapley values
Explain_stats ( model_exp,  probs = 0.95)
}
}
