% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/baf.R
\name{baf}
\alias{baf}
\title{Download Block Assignment Files (BAF) from the Census Bureau}
\usage{
baf(
  state,
  year = 2020,
  geographies = NULL,
  cache_to = baf_download_path(),
  overwrite = FALSE
)
}
\arguments{
\item{state}{state to download data for.}

\item{year}{year to download data for. Default is \code{2020}.}

\item{geographies}{geography types to download. Default is \code{NULL}, which gets all available geographies.}

\item{cache_to}{directory name to save the downloaded data. Default is \code{baf_download_path()}.}

\item{overwrite}{Should the data be re-downloaded? Default is \code{FALSE}.}
}
\value{
a list of \link{tibble}s for each geography type
}
\description{
Download Block Assignment Files (BAF) from the Census Bureau
}
\examples{
baf('DE', 2020)
}
