% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sync.R
\name{am_change_from_bytes}
\alias{am_change_from_bytes}
\title{Parse a serialized change from raw bytes}
\usage{
am_change_from_bytes(bytes)
}
\arguments{
\item{bytes}{A raw vector containing a serialized change (from
\code{\link[=am_change_to_bytes]{am_change_to_bytes()}})}
}
\value{
An \code{am_change} object (external pointer) that can be passed to
\code{\link[=am_change_hash]{am_change_hash()}}, \code{\link[=am_change_message]{am_change_message()}}, \code{\link[=am_change_time]{am_change_time()}},
\code{\link[=am_change_actor_id]{am_change_actor_id()}}, \code{\link[=am_change_seq]{am_change_seq()}}, and \code{\link[=am_change_deps]{am_change_deps()}}.
}
\description{
Deserializes a change from raw bytes into an \code{am_change} object. This is
useful for restoring changes that were previously serialized with
\code{\link[=am_change_to_bytes]{am_change_to_bytes()}} or saved to disk.
}
\details{
Note: \code{\link[=am_get_changes]{am_get_changes()}}, \code{\link[=am_get_changes]{am_get_changes()}}, and other change-returning
functions already return \code{am_change} objects directly, so this function
is only needed when working with raw byte representations.
}
\examples{
doc <- am_create()
am_put(doc, AM_ROOT, "key", "value")
am_commit(doc, "Add key")

# Serialize a change and restore it
history <- am_get_changes(doc)
bytes <- am_change_to_bytes(history[[1]])
change <- am_change_from_bytes(bytes)
change
am_change_message(change)  # "Add key"

am_close(doc)

}
