% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{as.character.am_text}
\alias{as.character.am_text}
\title{Convert text object to character string}
\usage{
\method{as.character}{am_text}(x, ...)
}
\arguments{
\item{x}{An Automerge text object}

\item{...}{Additional arguments (unused)}
}
\value{
Character string with the full text content
}
\description{
Extracts the full text content from an Automerge text object as a standard
character string.
}
\examples{
doc <- am_create()

am_put(doc, AM_ROOT, "notes", am_text("Hello World"))
text_obj <- am_get(doc, AM_ROOT, "notes")

text_string <- as.character(text_obj)
text_string  # "Hello World"

identical(as.character(text_obj), am_text_content(text_obj))  # TRUE

am_close(doc)

}
