% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sync.R
\name{am_sync_decode}
\alias{am_sync_decode}
\title{Receive and apply a sync message}
\usage{
am_sync_decode(doc, sync_state, message)
}
\arguments{
\item{doc}{An Automerge document}

\item{sync_state}{A sync state object (created with \code{am_sync_state_new()})}

\item{message}{A raw vector containing an encoded sync message}
}
\value{
The document \code{doc} (invisibly, for chaining)
}
\description{
Receives a synchronization message from a peer and applies the changes
to the local document. This updates both the document and the sync state
to reflect the received changes.
}
\examples{
doc <- am_create()
sync_state <- am_sync_state_new()

# Receive message from peer
# message <- ... (received from network)
# am_sync_decode(doc, sync_state, message)

am_close(doc)

}
