% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_numbers.R
\name{group_numbers}
\alias{group_numbers}
\title{Convert Numbers into Padded Strings for Easier Group Numbering}
\usage{
group_numbers(numbers)
}
\arguments{
\item{numbers}{A numeric vector with a length of at least 1.}
}
\value{
A Character Vector
}
\description{
Convert Numbers into Padded Strings for Easier Group Numbering
}
\examples{
# Useful for easier group numbering so groups are ordered as intended
# Expects a numeric vector of numbers to convert to padded numbers
regular_numbers <- 1:19
padded_numbers <- group_numbers(regular_numbers)

# The padding matters when creating labels for groupings
# as numbers will be converted to characters if attached to strings.
# Sorts as expected:
sort(regular_numbers)

# Does not as a character:
sort(paste0("group_", regular_numbers))

# Will sort as expected when padded:
sort(paste0("group_", padded_numbers))
}
