% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{readProfiles}
\alias{readProfiles}
\title{Read Argo Profiles From Local Files}
\usage{
readProfiles(
  profiles,
  FUN,
  destdir = argoDefaultDestdir(),
  quiet = FALSE,
  debug = 0
)
}
\arguments{
\item{profiles}{either (1) a character vector that holds
the names of NetCDF files or (2) an \code{\linkS4class{argoFloats}}
object created by \code{\link[=getProfiles]{getProfiles()}}. In the first case, any
items that start with \code{"ftp:"} are taken to represent
the full paths to remote files, and these first downloaded
to the \code{destdir} directory using \code{\link[=getProfileFromUrl]{getProfileFromUrl()}}.}

\item{FUN}{a function that reads the NetCDF files in which the argo
profiles are stored.  If \code{FUN} not provided, then it defaults
to \code{\link[oce:read.argo]{oce::read.argo()}}.  Only experts should consider anything
other than this default, or a wrapper to it.}

\item{destdir}{character value indicating the directory in which to store
downloaded files. The default value is to compute this using
\code{\link[=argoDefaultDestdir]{argoDefaultDestdir()}}, which returns \verb{~/data/argo} by default,
although it also provides ways to set other values using
\code{\link[=options]{options()}}.
Set \code{destdir=NULL}
if \code{destfile} is a filename with full path information.
File clutter is reduced by creating a top-level directory called
\code{data}, with subdirectories for various file types; see
\dQuote{Examples}.}

\item{quiet}{logical value; use \code{FALSE} to show more
verbose information when downloading files.
(Even if \code{quiet} is TRUE, problems will still be reported.)}

\item{debug}{an integer specifying the level of debugging. If
this is zero, the work proceeds silently. If it is 1,
a small amount of debugging information is printed.  Note that
\code{debug-1} is passed to \code{\link[oce:read.argo]{oce::read.argo()}}, which actually reads
the file, and so it will print messages if \code{debug} exceeds 1.}
}
\value{
An \code{\linkS4class{argoFloats}} object
with \code{type="argos"}, in which the \code{data} slot
contains a list named \code{argos} that holds objects
that are created by \code{\link[oce:read.argo]{oce::read.argo()}}.
}
\description{
This works with either a vector of NetCDF files,
or a \code{\linkS4class{argoFloats}} object of type \code{"profiles"}, as
created by \code{\link[=getProfiles]{getProfiles()}}.
During the reading, argo profile objects are created with \code{\link[oce:read.argo]{oce::read.argo()}}
or a replacement function provided as the \code{FUN} argument.
}
\details{
By default, warnings are issued about any
profiles in which 10 percent or more of the measurements are flagged
with a quality-control code of 0, 3, 4, 6, 7, or 9 (see the
\code{\link[=applyQC]{applyQC()}} documentation for the meanings of these codes). For more
on this function, see section 2 of Kelley et al. (2021).
}
\examples{
# Read from a local file
f <- system.file("extdata", "SR2902204_131.nc", package="argoFloats")
p <- readProfiles(f)

}
\references{
Kelley, D. E., Harbin, J., & Richards, C. (2021). argoFloats: An R package for analyzing
Argo data. Frontiers in Marine Science, (8), 636922.
\doi{10.3389/fmars.2021.635922}
}
\author{
Dan Kelley
}
