% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createBindingConstraint.R
\name{createBindingConstraintBulk}
\alias{createBindingConstraintBulk}
\title{Create multiple binding constraint at once.}
\usage{
createBindingConstraintBulk(constraints, opts = antaresRead::simOptions())
}
\arguments{
\item{constraints}{A \code{list} of several named \code{list} containing data to create binding constraints.
\strong{Warning} all arguments for creating a binding constraints must be provided, see examples.}

\item{opts}{List of simulation parameters returned by the function
\code{\link[antaresRead:setSimulationPath]{antaresRead::setSimulationPath()}}}
}
\value{
An updated list containing various information about the simulation.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
\ifelse{html}{\figure{badge_api_no.svg}{options: alt='Antares API NO'}}{Antares API: \strong{NO}}
}
\details{
According to Antares version, usage may vary :

\strong{>= v8.7.0} :
\itemize{
\item For each constraint name, one file .txt containing \verb{<id>_lt.txt, <id>_gt.txt, <id>_eq.txt}.
\item Parameter \code{values} must be named \code{list} ("lt", "gt", "eq") containing \code{data.frame} scenarized.
\item Add parameter \code{group} in input list \code{constraints}
}

see example section below.
}
\examples{
\dontrun{
# For Study version < v8.7.0
# Create multiple constraints

# Prepare data for constraints 
bindings_constraints <- lapply(
  X = seq_len(100),
  FUN = function(i) {
    # use arguments of createBindingConstraint()
    # all arguments must be provided !
    list(
      name = paste0("constraints", i), 
      id = paste0("constraints", i), 
      values = matrix(data = rep(0, 8760 * 3), ncol = 3), 
      enabled = FALSE, 
      timeStep = "hourly",
      operator = "both",
      coefficients = list("area1\%area2" = 1),
      overwrite = TRUE
    )
  }
)
# create all constraints
createBindingConstraintBulk(bindings_constraints)

# For Study version >= v8.7.0 (add parameter `group`)

# data values (hourly)
df <- matrix(data = rep(0, 8760 * 3), ncol = 3)
values_data <- list(lt=df, 
                    gt= df)   

# create multiple constraints
bindings_constraints <- lapply(
  X = seq_len(10),
  FUN = function(i) {
    # use arguments of createBindingConstraint()
    # all arguments must be provided !
    list(
      name = paste0("constraints_bulk", i), 
      id = paste0("constraints_bulk", i), 
      values = values_data, 
      enabled = FALSE, 
      timeStep = "hourly",
      operator = "both",
      coefficients = list("at\%fr" = 1),
      group= "group_bulk",
     overwrite = TRUE
   )
  }
)
 
createBindingConstraintBulk(bindings_constraints)  
}

}
\seealso{
Other binding constraints functions: 
\code{\link{createBindingConstraint}()},
\code{\link{editBindingConstraint}()},
\code{\link{removeBindingConstraint}()}
}
\concept{binding constraints functions}
