% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aldvmmMethods.R
\name{predict.aldvmm}
\alias{predict.aldvmm}
\title{Predict Method for Adjusted Limited Dependent Variable Mixture Model Fits}
\usage{
\method{predict}{aldvmm}(
  object,
  newdata = NULL,
  se.fit = FALSE,
  type = "pred",
  level = 0.95,
  ...
)
}
\arguments{
\item{object}{an object inheriting from class 'aldvmm'.}

\item{newdata}{a data frame, list or environment (or object coercible to a
data frame by \cr \ifelse{html}{\code{\link[base]{as.data.frame}}}{
\code{base::as.data.frame()}}) including explanatory variables for
prediction.}

\item{se.fit}{an optional logical value indicating whether standard errors
of fitted values are calculated. The default value is \code{FALSE}.}

\item{type}{a character value of either 'fit' or 'pred' indicating whether
the standard error of the fit ('fit') or the standard error of predictions
in new data ('pred') are calculated.}

\item{level}{a numeric value of the significance level for confidence bands
of fitted values. The default value is 0.95.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a named list of numeric vectors of predicted outcomes, standard
  errors and confidence or prediction intervals.
}
\description{
The method \code{predict.aldvmm} for the generic function
\ifelse{html}{\code{\link[stats]{predict}}}{\code{stats::predict()}} calls
\ifelse{html}{\code{\link[aldvmm]{aldvmm.pred}}}{\code{aldvmm.pred()}} and \ifelse{html}{\code{\link[aldvmm]{aldvmm.sefit}}}{\code{aldvmm.sefit()}} to
predict outcomes and their standard errors in new data.
}
