% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{aov_test}
\alias{aov_test}
\title{aov_test}
\usage{
aov_test(df, variable_name, group)
}
\arguments{
\item{df}{A data frame.}

\item{variable_name}{Name of the response variable column (string).}

\item{group}{Name of the grouping column (string).}
}
\value{
A named list with elements \code{anova_summary}, \code{tukey_results},
  and \code{compact_letters}.
}
\description{
Perform one-way ANOVA followed by Tukey HSD post-hoc test with
  compact letter display.
}
\examples{
df <- data.frame(
  grp = rep(c("A","B","C"), each = 5),
  val = c(1,2,1,2,1, 3,4,3,4,3, 5,6,5,6,5)
)
aov_test(df, "val", "grp")
}
