% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duplicates.R
\name{extract_duplicate_records}
\alias{extract_duplicate_records}
\title{Extract Duplicate Records}
\usage{
extract_duplicate_records(dataset, by_vars = NULL)
}
\arguments{
\item{dataset}{Input dataset

The variables specified by the \code{by_vars} argument are expected to be in the dataset.

\describe{
\item{Default value}{none}
}}

\item{by_vars}{Grouping variables

Defines groups of records in which to look for duplicates.
If omitted, all variables in the input dataset are used in the by group.

\strong{Note:}  Omitting \code{by_vars} will increase the function's run-time, so it is
recommended to specify the necessary grouping variables for large datasets
whenever possible.

\describe{
\item{Permitted values}{list of variables created by \code{exprs()}, e.g., \code{exprs(USUBJID, VISIT)}}
\item{Default value}{\code{NULL}}
}}
}
\value{
A \code{data.frame} of duplicate records within \code{dataset}
}
\description{
Extract Duplicate Records
}
\examples{
data(admiral_adsl)

# Duplicate the first record
adsl <- rbind(admiral_adsl[1L, ], admiral_adsl)

extract_duplicate_records(adsl, exprs(USUBJID))
}
\seealso{
Other internal: 
\code{\link{admiral-package}},
\code{\link{format.basket_select}()},
\code{\link{signal_duplicate_records}()}
}
\concept{internal}
\keyword{internal}
