% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github_release_utils.R
\name{create_sqlite_hash_file}
\alias{create_sqlite_hash_file}
\title{Create SHA256 hash file for a SQLite database}
\usage{
create_sqlite_hash_file(sqlite_path, output_file = NULL, algo = "sha256")
}
\arguments{
\item{sqlite_path}{Path to the SQLite file.}

\item{output_file}{Optional output path for the hash file.
Defaults to \verb{<sqlite_path>.sha256}.}

\item{algo}{Hash algorithm (default: \code{"sha256"}).}
}
\value{
Invisibly returns the path to the hash file.
}
\description{
Computes a SHA256 hash for a SQLite database file and writes it to
a \code{.sha256} file. The hash file can be uploaded alongside the database
in a GitHub release to allow version comparison without downloading
the full database.
}
\examples{
\dontrun{
create_sqlite_hash_file("database.sqlite")
}
}
