% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regressionImp.R
\name{regressionImp}
\alias{regressionImp}
\title{Regression Imputation}
\usage{
regressionImp(
  formula,
  data,
  family = "AUTO",
  robust = FALSE,
  imp_var = TRUE,
  imp_suffix = "imp",
  mod_cat = FALSE
)
}
\arguments{
\item{formula}{model formula to impute one variable}

\item{data}{A data.frame containing the data}

\item{family}{family argument for \code{\link[=glm]{glm()}}. \code{"AUTO"} (the default) tries to choose
automatically and is the only really tested option!!!}

\item{robust}{\code{TRUE}/\code{FALSE} if robust regression should be used. See details.}

\item{imp_var}{\code{TRUE}/\code{FALSE} if a \code{TRUE}/\code{FALSE} variables for each imputed
variable should be created show the imputation status}

\item{imp_suffix}{suffix used for TF imputation variables}

\item{mod_cat}{\code{TRUE}/\code{FALSE} if \code{TRUE} for categorical variables the level with
the highest prediction probability is selected, otherwise it is sampled
according to the probabilities.}
}
\value{
the imputed data set.
}
\description{
Impute missing values based on a regression model.
}
\details{
\code{\link[=lm]{lm()}} is used for family "normal" and \code{\link[=glm]{glm()}} for all other families.
If \code{robust = TRUE}, \link[robustbase:lmrob]{lmrob()} is used for family "normal"
and \link[robustbase:glmrob]{glmrob()} for all other families.
}
\examples{

data(sleep)
sleepImp1 <- regressionImp(Dream+NonD~BodyWgt+BrainWgt,data=sleep)
sleepImp2 <- regressionImp(Sleep+Gest+Span+Dream+NonD~BodyWgt+BrainWgt,data=sleep)

data(testdata)
imp_testdata1 <- regressionImp(b1+b2~x1+x2,data=testdata$wna)
imp_testdata3 <- regressionImp(x1~x2,data=testdata$wna,robust=TRUE)

}
\references{
A. Kowarik, M. Templ (2016) Imputation with
R package VIM.  \emph{Journal of
Statistical Software}, 74(7), 1-16.
}
\seealso{
Other imputation methods: 
\code{\link{hotdeck}()},
\code{\link{impPCA}()},
\code{\link{irmi}()},
\code{\link{kNN}()},
\code{\link{matchImpute}()},
\code{\link{medianSamp}()},
\code{\link{rangerImpute}()},
\code{\link{sampleCat}()},
\code{\link{xgboostImpute}()}
}
\author{
Alexander Kowarik
}
\concept{imputation methods}
\keyword{manip}
