% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/te_weights.R
\name{weight_model_data_indices}
\alias{weight_model_data_indices}
\title{Data used in weight model fitting}
\usage{
weight_model_data_indices(
  object,
  type = c("switch", "censor"),
  model,
  set_col = NULL
)
}
\arguments{
\item{object}{A \link{trial_sequence} object}

\item{type}{Select a censoring or switching model}

\item{model}{The model name}

\item{set_col}{A character string to specifying a new column to contain indicators for observations used in
fitting this model.}
}
\value{
If \code{set_col} is not specified a logical \code{data.table} column is returned. Otherwise
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
trial_pp <- trial_sequence("PP") |>
  set_data(data_censored) |>
  set_switch_weight_model(
    numerator = ~age,
    denominator = ~ age + x1 + x3,
    model_fitter = stats_glm_logit(tempdir())
  ) |>
  calculate_weights()
ipw_data(trial_pp)
show_weight_models(trial_pp)

# get logical column for own processing
i <- weight_model_data_indices(trial_pp, "switch", "d0")

# set column in data
weight_model_data_indices(trial_pp, "switch", "d0", set_col = "sw_d0")
weight_model_data_indices(trial_pp, "switch", "d1", set_col = "sw_d1")
ipw_data(trial_pp)
}
