% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_distribution_summary_tbl.R
\name{tidy_distribution_summary_tbl}
\alias{tidy_distribution_summary_tbl}
\title{Tidy Distribution Summary Statistics Tibble}
\usage{
tidy_distribution_summary_tbl(.data, ...)
}
\arguments{
\item{.data}{The data that is going to be passed from a a \code{tidy_} distribution
function.}

\item{...}{This is the grouping variable that gets passed to \code{\link[dplyr:group_by]{dplyr::group_by()}}
and \code{\link[dplyr:select]{dplyr::select()}}.}
}
\value{
A summary stats tibble
}
\description{
This function returns a summary statistics tibble. It will use the
y column from the \code{tidy_} distribution function.
}
\details{
This function takes in a \code{tidy_} distribution table and
will return a tibble of the following information:
\itemize{
\item \code{sim_number}
\item \code{mean_val}
\item \code{median_val}
\item \code{std_val}
\item \code{min_val}
\item \code{max_val}
\item \code{skewness}
\item \code{kurtosis}
\item \code{range}
\item \code{iqr}
\item \code{variance}
\item \code{ci_hi}
\item \code{ci_lo}
}

The kurtosis and skewness come from the package \code{healthyR.ai}
}
\examples{
library(dplyr)

tn <- tidy_normal(.num_sims = 5)
tb <- tidy_beta(.num_sims = 5)

tidy_distribution_summary_tbl(tn)
tidy_distribution_summary_tbl(tn, sim_number)

data_tbl <- tidy_combine_distributions(tn, tb)

tidy_distribution_summary_tbl(data_tbl)
tidy_distribution_summary_tbl(data_tbl, dist_type)

}
\author{
Steven P. Sanderson II, MPH
}
\concept{Summary Statistics}
\concept{Table Data}
