% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateTumorGrowth.R
\name{simulateTumorGrowth}
\alias{simulateTumorGrowth}
\title{Helper function to simulate tumor growth data for a two-drug combination experiment.}
\usage{
simulateTumorGrowth(
  npg = 5,
  timepoints = c(0, 3, 5, 10),
  initial_volume = 100,
  grwrControl = 0.08,
  grwrA = 0.07,
  grwrB = 0.06,
  grwrComb = 0.04,
  sd = 0.1
)
}
\arguments{
\item{npg}{Number of samples per group.}

\item{timepoints}{Vector with the time points at which the tumor volume measurements have been performed.}

\item{initial_volume}{Initial volume for the tumor growth.}

\item{grwrControl}{Coefficient for Control treatment group tumor growth rate.}

\item{grwrA}{Coefficient for Drug A treatment group tumor growth rate.}

\item{grwrB}{Coefficient for Drug B treatment group tumor growth rate.}

\item{grwrComb}{Coefficient for Combination (Drug A + Drug B) treatment group tumor growth rate.}

\item{sd}{Variability for the tumor growth.}
}
\value{
A data frame with tumor growth data in long format.
}
\description{
Helper function to simulate tumor growth data for a two-drug combination experiment.
}
\details{
The function simulates the tumor growth following exponential kinetics,
given by
\deqn{TV(t) = TV_0 \cdot e^{\beta_i \cdot t}}

where \eqn{TV_0} is given by \code{initial_volume}, \eqn{t} is given by \code{timepoints}
and \eqn{\beta_i} are the coefficients given by \code{grwrControl}, \code{grwrA}, \code{grwrB}, and \code{grwrComb}.

The variability is simulated using the \code{sd} argument to add random noise from a normal distribution \eqn{N(1, SD)},
with \eqn{SD} = \code{sd}.
}
\examples{
# This code generates the 'grwth_data' example dataset:
set.seed(123)
grwth_data <- simulateTumorGrowth(npg = 8, timepoints = seq(0,30,3), 
                                   initial_volume = 200, grwrControl = 0.08,
                                   grwrA = 0.07, grwrB = 0.065, 
                                   grwrComb = 0.04, sd = 0.2)

}
