% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getters.R
\name{get_comparisons}
\alias{get_comparisons}
\title{Retrieve metadata for the SkeletalVis database}
\usage{
get_comparisons(skeletalvis, accession = NULL)
}
\arguments{
\item{skeletalvis}{The path to the SkeletalVis data folder.}

\item{accession}{Optionally an experiment accession number for the experiment of interest to filter the metadata by.}
}
\value{
A dataframe containing metadata.
}
\description{
`get_comparisons`Retieves the metadata file containing accession and comparison information
for the skeletalvis database.
}
\examples{
# Get the path to the directory with the accessions.txt file
skeletalvis_path <- load_skeletalvis(demo=TRUE)

# Retrieve the metadata
metadata <- get_comparisons(skeletalvis_path)

# View the metadata
head(metadata)

metadata <- get_comparisons(skeletalvis_path, "GSE85761")
}
