% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{check_stationarity}
\alias{check_stationarity}
\title{Check Stationarity of AR Coefficients}
\usage{
check_stationarity(phi)
}
\arguments{
\item{phi}{Numeric vector of AR coefficients (phi_1, phi_2, ..., phi_p).}
}
\value{
A list with:
\describe{
\item{is_stationary}{Logical indicating whether the process is stationary}
\item{roots}{Complex roots of the characteristic polynomial}
\item{moduli}{Moduli of the roots}
}
}
\description{
Verifies whether autoregressive coefficients satisfy stationarity conditions
by checking that all roots of the characteristic polynomial lie outside
the unit circle.
}
\details{
For an AR(p) process, stationarity requires that all roots of the
characteristic polynomial \eqn{1 - \phi_1 z - \phi_2 z^2 - ... - \phi_p z^p}
have modulus greater than 1. This is equivalent to requiring that all roots
of the polynomial lie outside the unit circle in the complex plane.

The function constructs the companion matrix and computes its eigenvalues,
which are the inverses of the characteristic polynomial roots.
}
\references{
Hamilton, J. D. (1994). Time Series Analysis. Princeton University Press.
Chapter 1.
}
\keyword{internal}
