% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/safe_map_all.R
\name{s_future_map}
\alias{s_future_map}
\alias{s_future_map_chr}
\alias{s_future_map_dbl}
\alias{s_future_map_int}
\alias{s_future_map_lgl}
\alias{s_future_map_dfr}
\alias{s_future_map_dfc}
\title{Safe Future Map - Parallel with Auto-Recovery}
\usage{
s_future_map(
  .x,
  .f,
  ...,
  .options = NULL,
  .env_globals = parent.frame(),
  .progress = FALSE,
  .id = NULL,
  .session_id = NULL
)

s_future_map_chr(
  .x,
  .f,
  ...,
  .options = NULL,
  .env_globals = parent.frame(),
  .progress = FALSE,
  .id = NULL,
  .session_id = NULL
)

s_future_map_dbl(
  .x,
  .f,
  ...,
  .options = NULL,
  .env_globals = parent.frame(),
  .progress = FALSE,
  .id = NULL,
  .session_id = NULL
)

s_future_map_int(
  .x,
  .f,
  ...,
  .options = NULL,
  .env_globals = parent.frame(),
  .progress = FALSE,
  .id = NULL,
  .session_id = NULL
)

s_future_map_lgl(
  .x,
  .f,
  ...,
  .options = NULL,
  .env_globals = parent.frame(),
  .progress = FALSE,
  .id = NULL,
  .session_id = NULL
)

s_future_map_dfr(
  .x,
  .f,
  ...,
  .options = NULL,
  .env_globals = parent.frame(),
  .progress = FALSE,
  .id = NULL,
  .session_id = NULL
)

s_future_map_dfc(
  .x,
  .f,
  ...,
  .options = NULL,
  .env_globals = parent.frame(),
  .progress = FALSE,
  .id = NULL,
  .session_id = NULL
)
}
\arguments{
\item{.x}{A list or atomic vector.}

\item{.f}{A function, formula, or vector.}

\item{...}{Additional arguments passed to .f.}

\item{.options}{A furrr_options object (NULL uses defaults).}

\item{.env_globals}{The environment to look for globals.}

\item{.progress}{A single logical.}

\item{.id}{Optional name for ID column (dfr/dfc variants).}

\item{.session_id}{Character. Optional session ID.}
}
\value{
A list.
}
\description{
Parallel mapping with automatic checkpointing. Requires the furrr package.
}
\examples{
\donttest{
library(future)
plan(multisession)
result <- s_future_map(1:100, ~ .x^2)
plan(sequential)  
}
}
