% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcov.R
\name{vcov.SSN2}
\alias{vcov.SSN2}
\alias{vcov.ssn_lm}
\alias{vcov.ssn_glm}
\title{Calculate variance-covariance matrix for a fitted model object}
\usage{
\method{vcov}{ssn_lm}(object, ...)

\method{vcov}{ssn_glm}(object, var_correct = TRUE, ...)
}
\arguments{
\item{object}{A fitted model object from \code{\link[=ssn_lm]{ssn_lm()}} or \code{\link[=ssn_glm]{ssn_glm()}}.}

\item{...}{Other arguments. Not used (needed for generic consistency).}

\item{var_correct}{A logical indicating whether to return the corrected variance-covariance
matrix for models fit using \code{\link[=ssn_glm]{ssn_glm()}} (when \code{family} is different
from \code{"Gaussian"}). The default is \code{TRUE}.}
}
\value{
The variance-covariance matrix of coefficients obtained via \code{coef()}.
Currently, only the variance-covariance matrix of the fixed effects is supported.
}
\description{
Calculate variance-covariance matrix for a fitted model object.
}
\examples{
# Copy the mf04p .ssn data to a local directory and read it into R
# When modeling with your .ssn object, you will load it using the relevant
# path to the .ssn data on your machine
copy_lsn_to_temp()
temp_path <- paste0(tempdir(), "/MiddleFork04.ssn")
mf04p <- ssn_import(temp_path, overwrite = TRUE)

ssn_mod <- ssn_lm(
  formula = Summer_mn ~ ELEV_DEM,
  ssn.object = mf04p,
  tailup_type = "exponential",
  additive = "afvArea"
)
vcov(ssn_mod)
}
