% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RowGroups.R
\name{any_duplicated_rows}
\alias{any_duplicated_rows}
\title{Fast alternative to \code{anyDuplicated()}}
\usage{
any_duplicated_rows(x, cols = names(x))
}
\arguments{
\item{x}{A data frame, tibble, or data.table.}

\item{cols}{Columns to check for duplicates.}
}
\value{
Index of the first duplicate row, if any; otherwise 0.
}
\description{
Implemented similarly to \code{\link[=RowGroups]{RowGroups()}}.
}
\details{
With \code{data.table} input and the data.table package available,
\code{anyDuplicated.data.table()} will be used.
}
\examples{
z <- SSBtoolsData("power10to2")
head(z, 12)
tail(z)

any_duplicated_rows(z, c("A", "B"))
any_duplicated_rows(z, c("a", "A", "B"))
any_duplicated_rows(z, c("a", "A", "b"))
}
