% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elicitSurvivalExtrapolation.R
\name{elicitSurvivalExtrapolation}
\alias{elicitSurvivalExtrapolation}
\title{Elicitation for survival extrapolation}
\usage{
elicitSurvivalExtrapolation()
}
\description{
Opens up a web browser in which you can implement the SHELF protocol for survival extrapolation.
Start with uploading a .csv file of individual patient survival data (time, event to indicate censoring, and
treatment group). Then elicit individual judgements, perform scenario testing as required, and elicit a RIO distribution.
Judgements for two treatment groups can be elicited in the same session.
}
\examples{

\dontrun{

# make a suitable csv file using a built in data set from the survival package
sdf <- survival::veteran[, c("time", "status", "trt")]
colnames(sdf) <- c("time", "event", "treatment")
sdf$treatment <- factor(sdf$treatment, labels = c("standard", "test"))

# write the data frame sdf to a .csv file in the current working directory
write.csv(sdf, file = "testFile.csv", row.names = FALSE)

# Run the app and upload testFile.csv in the first tab, and change unit of time to "days"

elicitSurvivalExtrapolation()

}
}
\author{
Jeremy Oakley <j.oakley@sheffield.ac.uk>
}
