% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformations.R
\name{get_Q}
\alias{get_Q}
\title{Estimation of spectral transformation}
\usage{
get_Q(X, type, trim_quantile = 0.5, q_hat = 0, scaling = TRUE)
}
\arguments{
\item{X}{Numerical covariates of class \code{matrix}.}

\item{type}{Type of deconfounding, one of 'trim', 'pca', 'no_deconfounding'. 
'trim' corresponds to the Trim transform \insertCite{Cevid2020SpectralModels}{SDModels} 
as implemented in the Doubly debiased lasso \insertCite{Guo2022DoublyConfounding}{SDModels}, 
'pca' to the PCA transformation\insertCite{Paul2008PreconditioningProblems}{SDModels} 
and 'no_deconfounding' to the Identity.}

\item{trim_quantile}{Quantile for Trim transform, only needed for trim.}

\item{q_hat}{Assumed confounding dimension, only needed for pca.}

\item{scaling}{Whether X should be scaled before calculating the spectral transformation.}
}
\value{
Q of class \code{matrix}, the spectral transformation matrix.
}
\description{
Estimates the spectral transformation Q for spectral deconfounding by 
shrinking the leading singular values of the covariates.
}
\examples{
set.seed(1)
X <- matrix(rnorm(50 * 20), nrow = 50)
Q_trim <- get_Q(X, 'trim')
Q_pca <- get_Q(X, 'pca', q_hat = 5)
Q_plain <- get_Q(X, 'no_deconfounding')
}
\references{
\insertAllCited{}
}
\author{
Markus Ulmer
}
