% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_rvp_fill_template.R
\name{rvn_rvp_fill_template}
\alias{rvn_rvp_fill_template}
\title{Rewrite template rvp file with values}
\usage{
rvn_rvp_fill_template(
  rvi_file = NULL,
  rvh_file = NULL,
  rvp_template_file = NULL,
  fileprefix = NULL,
  rvp_out = NULL,
  overwrite = FALSE,
  default_param_value = 0.12345,
  default_soil_thickness = 0.5,
  use_default_flag = FALSE,
  avg_annual_runoff = NULL,
  extra_commands = NULL,
  RavenParamsFile = system.file("extdata", "RavenParameters.dat", package = "RavenR")
)
}
\arguments{
\item{rvi_file}{path to the model *.rvi file}

\item{rvh_file}{path to the model *.rvh file}

\item{rvp_template_file}{path to the model rvp template file (*.rvp_temp.rvp)}

\item{fileprefix}{model name prefix for the main model files; if provided, the function will attempt to find all missing file paths in the current working directory}

\item{rvp_out}{file path to rewritten rvp file}

\item{overwrite}{logical for whether to rewrite the *.rvp file if it already exists (default FALSE)}

\item{default_param_value}{default parameter value to write for any parameters not found in RavenParameters.dat}

\item{default_soil_thickness}{default soil layer thickness (m) to provide in :SoilProfile block}

\item{use_default_flag}{writes all soil/land use/vegetation classes with [DEFAULT] flag}

\item{avg_annual_runoff}{adds a line for :AvgAnnualRunoff if value provided with this parameter and not already in file}

\item{extra_commands}{additional commands to add to end of rvp file as character vector}

\item{RavenParamsFile}{path to RavenParameters.dat file (default path points to file included with RavenR installation)}
}
\value{
\code{TRUE} if the function executed successfully
}
\description{
Rewrites a Raven template rvp file with default parameter values.
}
\details{
The Raven rvp template file is generated by Raven when the :CreateRVPTemplate command is included in the
rvi file (the default when \code{\link{rvn_rvi_write_template}} is used to produce an rvi file). This
template file displays the layout of the rvp file with required parameters based on the hydrologic processes
in the rvi file, but is not immediately usable. This function uses the soil model information in the rvi file
and the HRU class information in the rvh file to rewrite the template file with default parameter values so that
it can be used in a model run.

If \code{rvp_out} is not provided, Raven will attempt to write to the file prefix of the provided template file with a .rvp extension.
If there is a conflict with an existing file and \code{overwrite==FALSE}, the function will automatically overwrite a file
with the suffix "_ravenr_generated.rvp".

The default parameter values come from the RavenParameters.dat file included with RavenR in the extdata folder. The
user may provide their own file with updated values if preferred. Note that the database files held in the RavenR
package are unofficial copies of those in the official Raven SVN, and any discrepancies should defer to the Raven SVN versions.

Any parameters not found in this file will be written
with the value provided by \code{default_param_value}. The default soil thickness for the :SoilProfiles block is provided
by the \code{default_soil_thickness} function parameter, which is applied for all soil classes.

As an alternative to specifying the three input files (rvi, rvh, rvp_temp.rvp), the \code{fileprefix} of the model (e.g.
'Nith' for Nith.rvi) may be provided instead. If provided, the function will attempt to find all required input files based on
the provided fileprefix in the current working directory.

Additional commands can be added to the end of the rvp file with \code{extra_commands}, which are not quality controlled but
simply appended to the rvp file. This can be useful for non-standard commands such as :RedirectToFile for channel properties rvp files
that are not added automatically to base templates rvp files.

If you find parameters not found by this function, please open an ticket on Github (\url{https://github.com/rchlumsk/RavenR/issues}).
}
\examples{

### this section is not run, but illustrates how an rvp template file would be created
# -----
\dontrun{
## create an rvi file and template file with Raven
rvn_rvi_write_template(modelname="HBV-EC",
   filename="nithmodel.rvi")

## download Raven.exe if not already downloaded
if (!rvn_download(check=TRUE)) {
  rvn_download()
}

## run Raven to create template file
rvn_run(fileprefix="nithmodel")
}
# -----

# load pre-generated template file and other model files
nithmodel_template_file <- system.file("extdata","nithmodel.rvp_temp.rvp", package="RavenR")
nith_rvi_file <- system.file("extdata","Nith.rvi", package="RavenR")
nith_rvh_file <- system.file("extdata","Nith.rvh", package="RavenR")
rvp_out_file <- file.path(tempdir(), 'nithmodel.rvp')

# rewrite template with parameter values
rvn_rvp_fill_template(rvi_file=nith_rvi_file,
                      rvh_file=nith_rvh_file,
                      rvp_template_file=nithmodel_template_file,
                      rvp_out=rvp_out_file)

}
\seealso{
\code{\link{rvn_rvi_getparams}} to get parameter ranges from rvi.
}
