% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rd_dates.R
\name{rd_dates}
\alias{rd_dates}
\title{Transform Dates and Datetimes in REDCap Data}
\usage{
rd_dates(project = NULL, data = NULL, dic = NULL, event_form = NULL)
}
\arguments{
\item{project}{A list containing the REDCap data, dictionary, and event mapping (expected \code{redcap_data()} output). Overrides \code{data}, \code{dic}, and \code{event_form}.}

\item{data}{A \code{data.frame} or \code{tibble} with the REDCap dataset.}

\item{dic}{A \code{data.frame} with the REDCap dictionary.}

\item{event_form}{Only applicable for longitudinal projects (presence of events). Event-to-form mapping for longitudinal projects.}
}
\value{
A list with the following elements:
\describe{
\item{data}{The transformed dataset with date and datetime fields formatted as \code{Date} and \code{POSIXct}.}
\item{dictionary}{The original REDCap dictionary passed to the function.}
\item{event_form}{The original event-form mapping (if applicable).}
\item{results}{A summary of the transformations performed.}
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Converts date and datetime fields in a REDCap dataset to appropriate R classes.
}
\details{
The function performs the following tasks:
\itemize{
\item Detects date and datetime fields from the REDCap dictionary (\verb{date_*} and \verb{datetime_*} validation types).
\item Converts date fields to \code{Date} class.
\item Converts datetime fields to \code{POSIXct} class, treating empty strings as \code{NA}.
}
}
\examples{
result <- rd_dates(covican)
transformed_data <- result$data

}
