% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_SPD.R
\name{SPD_getVARproperties}
\alias{SPD_getVARproperties}
\title{Properties of VAR parameters}
\usage{
SPD_getVARproperties(p1Par, deltaPar, nPeriod)
}
\arguments{
\item{p1Par}{numeric vector of length 2, parameters of the prior for period 1.}

\item{deltaPar}{numeric vector of length 2, parameters of the prior for incremental changes.}

\item{nPeriod}{integer, number of periods.}
}
\value{
A list with the following components:
    \item{mean}{numeric vector of length nPeriod, prior means.}
    \item{sd}{numeric vector of length nPeriod, prior standard deviations.}
    \item{cor}{matrix of dim nPeriod*nPeriod, prior correlation matrix.}
}
\description{
This function computes the properties of VAR parameters (prior means, sds and correlation)
given the prior for period 1 and the prior for incremental changes.
}
\examples{
res=SPD_getVARproperties(p1Par=c(2,0.1),deltaPar=c(0,0.3),nPeriod=25)
image(res$cor)
}
