% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RUI.R
\name{BaM}
\alias{BaM}
\title{Run BaM}
\usage{
BaM(
  workspace,
  mod,
  data,
  remnant = rep(list(remnantErrorModel()), mod$nY),
  mcmc = mcmcOptions(),
  cook = mcmcCooking(),
  summary = mcmcSummary(),
  residuals = residualOptions(),
  pred = NULL,
  doCalib = TRUE,
  doPred = FALSE,
  na.value = -9999,
  run = TRUE,
  preClean = FALSE,
  dir.exe = .BAM_PATH,
  name.exe = "BaM",
  predMaster_fname = "Config_Pred_Master.txt"
)
}
\arguments{
\item{workspace}{Character, directory where config and result files are stored.}

\item{mod}{model object, the model to be calibrated}

\item{data}{dataset object, calibration data}

\item{remnant}{list of remnantErrorModel objects.
WARNING: make sure you use a list of length mod$nY (even if mod$nY=1!)}

\item{mcmc}{mcmcOptions object, MCMC simulation number and options}

\item{cook}{mcmcCooking object, properties of MCMC cooking (burn and slice)}

\item{summary}{mcmcSummary object, properties of MCMC summary}

\item{residuals}{residualOptions object, properties of residual analysis}

\item{pred}{list of prediction objects, properties of prediction experiments}

\item{doCalib}{Logical, do Calibration? (mcmc+cooking+summary+residuals)}

\item{doPred}{Logical, do Prediction?}

\item{na.value}{numeric, value used for NAs when writing the dataset in BaM format}

\item{run}{Logical, run BaM? if FALSE, just write config files.}

\item{preClean}{Logical, start by cleaning up workspace?
Be careful, this will delete all files in the workspace, including old results!}

\item{dir.exe}{Character, directory where BaM executable stands.}

\item{name.exe}{Character, name of the executable without extension ('BaM' by default).}

\item{predMaster_fname}{Character, name of configuration file pointing to all prediction experiments.}
}
\value{
Nothing: just write config files and runs the executable.
}
\description{
Run BaM.exe
}
\examples{
# Fitting a rating curve - see https://github.com/BaM-tools/RBaM
workspace=tempdir()
D=dataset(X=SauzeGaugings['H'],Y=SauzeGaugings['Q'],Yu=SauzeGaugings['uQ'],data.dir=workspace)
# Parameters of the low flow section control: activation stage k, coefficient a and exponent c
k1=parameter(name='k1',init=-0.5,prior.dist='Uniform',prior.par=c(-1.5,0))
a1=parameter(name='a1',init=50,prior.dist='LogNormal',prior.par=c(log(50),1))
c1=parameter(name='c1',init=1.5,prior.dist='Gaussian',prior.par=c(1.5,0.05))
# Parameters of the high flow channel control: activation stage k, coefficient a and exponent c
k2=parameter(name='k2',init=1,prior.dist='Gaussian',prior.par=c(1,1))
a2=parameter(name='a2',init=100,prior.dist='LogNormal',prior.par=c(log(100),1))
c2=parameter(name='c2',init=1.67,prior.dist='Gaussian',prior.par=c(1.67,0.05))
# Define control matrix: columns are controls, rows are stage ranges.
controlMatrix=rbind(c(1,0),c(0,1))
# Stitch it all together into a model object
M=model(ID='BaRatin',
        nX=1,nY=1, # number of input/output variables
        par=list(k1,a1,c1,k2,a2,c2), # list of model parameters
        xtra=xtraModelInfo(object=controlMatrix)) # use xtraModelInfo() to pass the control matrix
# Call BaM to write configuration files. To actually run BaM, use run=TRUE,
# but BaM executable needs to be downloaded first (use downloadBaM())
BaM(workspace=workspace,mod=M,data=D,run=FALSE)
}
