% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Result.R
\docType{methods}
\name{dbStatistics}
\alias{dbStatistics}
\alias{dbStatistics,AthenaResult-method}
\title{Show AWS Athena Statistics}
\usage{
dbStatistics(res, ...)

\S4method{dbStatistics}{AthenaResult}(res, ...)
}
\arguments{
\item{res}{An object inheriting from \linkS4class{DBIResult}.}

\item{...}{Other arguments passed on to methods.}
}
\value{
\code{dbStatistics()} returns list containing Athena Statistics return from \code{boto3}.
}
\description{
Returns AWS Athena Statistics from execute queries \code{\link{dbSendQuery}}
}
\examples{
\dontrun{
# Note:
# - Require AWS Account to run below example.
# - Different connection methods can be used please see `RAthena::dbConnect` documnentation

library(DBI)
library(RAthena)

# Demo connection to Athena using profile name
con <- dbConnect(RAthena::athena())

res <- dbSendQuery(con, "show databases")
dbStatistics(res)

# Clean up
dbClearResult(res)
}
}
