% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Connection.R
\docType{methods}
\name{dbConvertTable}
\alias{dbConvertTable}
\alias{dbConvertTable,AthenaConnection-method}
\title{Simple wrapper to convert Athena backend file types}
\usage{
dbConvertTable(conn, obj, name, ...)

\S4method{dbConvertTable}{AthenaConnection}(
  conn,
  obj,
  name,
  partition = NULL,
  s3.location = NULL,
  file.type = c("NULL", "csv", "tsv", "parquet", "json", "orc"),
  compress = TRUE,
  data = TRUE,
  ...
)
}
\arguments{
\item{conn}{An \code{\linkS4class{AthenaConnection}} object, produced by [DBI::dbConnect()]}

\item{obj}{Athena table or \code{SQL} DML query to be converted. For \code{SQL}, the query need to be wrapped with \code{DBI::SQL()} and
follow AWS Athena DML format \href{https://docs.aws.amazon.com/athena/latest/ug/select.html}{link}}

\item{name}{Name of destination table}

\item{...}{Extra parameters, currently not used}

\item{partition}{Partition Athena table}

\item{s3.location}{location to store output file, must be in s3 uri format for example ("s3://mybucket/data/").}

\item{file.type}{File type for \code{name}, currently support ["NULL","csv", "tsv", "parquet", "json", "orc"].
\code{"NULL"} will let Athena set the file type for you.}

\item{compress}{Compress \code{name}, currently can only compress ["parquet", "orc"] (\href{https://docs.aws.amazon.com/athena/latest/ug/create-table-as.html}{AWS Athena CTAS})}

\item{data}{If \code{name} should be created with data or not.}
}
\value{
\code{dbConvertTable()} returns \code{TRUE} but invisible.
}
\description{
Utilises AWS Athena to convert AWS S3 backend file types. It also also to create more efficient file types i.e. "parquet" and "orc" from SQL queries.
}
\examples{
\dontrun{
# Note:
# - Require AWS Account to run below example.
# - Different connection methods can be used please see `RAthena::dbConnect` documnentation

library(DBI)
library(RAthena)

# Demo connection to Athena using profile name
con <- dbConnect(athena())

# write iris table to Athena in defualt delimited format
dbWriteTable(con, "iris", iris)

# convert delimited table to parquet
dbConvertTable(con,
  obj = "iris",
  name = "iris_parquet",
  file.type = "parquet"
)

# Create partitioned table from non-partitioned
# iris table using SQL DML query
dbConvertTable(con,
  obj = SQL("select
                            iris.*,
                            date_format(current_date, '\%Y\%m\%d') as time_stamp
                          from iris"),
  name = "iris_orc_partitioned",
  file.type = "orc",
  partition = "time_stamp"
)

# disconnect from Athena
dbDisconnect(con)
}
}
