% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_effective_tax_rate.R
\name{calc_effective_tax_rate}
\alias{calc_effective_tax_rate}
\title{Calculate Effective Tax Rate}
\usage{
calc_effective_tax_rate(portfolio, tax_rate_ltcg, tax_rate_ordinary_income)
}
\arguments{
\item{portfolio}{A nested \code{tibble} of class \code{Portfolio}.}

\item{tax_rate_ltcg}{A numeric. Tax rate for long-term capital gains.}

\item{tax_rate_ordinary_income}{A numeric. Tax rate for ordinary income.}
}
\value{
A \code{portfolio} object augmented with nested columns with
effective tax rates calculations.
}
\description{
Calculate Effective Tax Rate
}
\examples{
 portfolio <- create_portfolio_template()
 portfolio$accounts$taxable <- c(10000, 30000)
 portfolio <- 
   calc_effective_tax_rate(
     portfolio,
     tax_rate_ltcg = 0.20, 
     tax_rate_ordinary_income = 0.40
   )
 portfolio$aftertax$effective_tax_rate 
}
