#' Details of deaths from all causes in England and Wales 1972-1992, taken from the
#' local mortality datapack
#' 
#' This dataset records the annual number of deaths in a given district in England
#' and Wales, covering 14 years (1972-1992) across 403 districts. Note that there are
#' only 5639 observations rather than the 5642 that might be expected (403 districts with
#' an observation for each of 14 years); 3 data points were removed because
#' extreme outlying values made them implausible.
#' 
#' The \code{lmdp} dataset is one of the example datasets analysed in
#' Leyland and Groenewegen (2020), and provided with the
#' multilevel-modelling software package MLwiN (Charlton et al., 2024).
#' 
#' @docType data
#' @format A data frame with 5639 observations on the following 8 variables:
#' \describe{
#' \item{county}{County (within region) identifier. There are 54 counties, coded
#' from 1 to 68.}
#' \item{district}{District (within county) identifier. There are 403 districts,
#' coded 101 to 6820.}
#' \item{region}{Region identifier. There are 10 regions, coded 1 to 10.}
#' \item{year}{Year, 1979 (\code{79}) to 1992 (\code{92}).}
#' \item{deaths}{Number of deaths observed}
#' \item{expected}{Expected number of deaths, based on the 1992 national age- and
#' sex- specific mortality rates.}
#' \item{smr}{Standardised mortality ratio (observed deaths / expected deaths * 100).}
#' \item{family}{District classification into one of 6 groups as defined by the UK's
#' Office for National Statistics (factor with levels
#' \code{Inner_London} (Inner London),
#' \code{Rural} (Rural areas),
#' \code{Prospering} (Prospering areas)
#' \code{Maturer} (Maturer areas),
#' \code{Urban} (Urban areas),
#' \code{Mining_industrial} (Mining and industrial areas).} }
#' @source Charlton, C., Rasbash, J., Browne, W.J., Healy, M. and Cameron, B. (2024)
#' \emph{MLwiN Version 3.08} Centre for Multilevel Modelling, University of
#' Bristol.
#' 
#' Leyland, A.H., Groenewegen, P.P. (2020). Multilevel Linear Regression Using
#' MLwiN: Mortality in England and Wales, 1979-1992. In: \emph{Multilevel
#' Modelling for Public Health and Health Services Research}. Springer, Cham. \doi{10.1007/978-3-030-34801-4_11}
#' @keywords datasets
#' @examples
#'
#' \dontrun{
#'
#' data(lmdp, package = "R2MLwiN") 
#' 
#' # Example taken from Leyland and Groenewegen (2020)
#' 
#' lmdp$ID <- seq(1:nrow(lmdp))
#' 
#' (mod_1 <- runMLwiN(smr ~ 1 + I(year - 79) +
#'                       (1 | district) + (1 | ID),
#'                    data = lmdp))
#' }
"lmdp"