% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-AK.R
\name{method.AK}
\alias{method.AK}
\title{AK Method}
\usage{
\method{method}{AK}(method_name, data, settings)
}
\arguments{
\item{method_name}{Method name (automatically passed)}

\item{data}{Data frame with yi (effect sizes), sei (standard errors), and study_id
(for clustering wherever available)}

\item{settings}{List of method settings (see Details)}
}
\value{
Data frame with AK results
}
\description{
Implements the Andrews & Kasy (AK) method for publication bias correction in meta-analysis.
The AK method categorizes estimated effects into groups with different probabilities of being
published. AK1 uses symmetric selection grouping estimates into significant (|t| >= 1.96) and
insignificant (|t| < 1.96) estimates. AK2 uses asymmetric selection with four groups based on
both significance and sign: highly significant positive/negative effects and marginally
significant positive/negative effects, each with different publication probabilities. See
\insertCite{andrews2019identification;textual}{PublicationBiasBenchmark} for details.
}
\details{
The following settings are implemented \describe{
\item{\code{"default"}}{Uses AK1 estimator (symmetric selection)}
\item{\code{"AK1"}}{Symmetric selection model grouping estimates into significant
(|t| >= 1.96) and insignificant (|t| < 1.96) categories with relative publication
probabilities of 1 and p1 respectively.}
\item{\code{"AK2"}}{Asymmetric selection model with four groups based on t-statistics:
(a) t >= 1.96, (b) t < -1.96, (c) -1.96 <= t < 0, and (d) 0 <= t < 1.96, with
relative publication probabilities of 1, p1, p2, and p3 respectively.}
}
}
\examples{
# Generate some example data
data <- data.frame(
  yi = c(0.2, 0.3, 0.1, 0.4, 0.25),
  sei = c(0.1, 0.15, 0.08, 0.12, 0.09)
)

# Apply AK method
result <- run_method("AK", data, "default")
print(result)

}
\references{
\insertAllCited{}
}
