## #############################################################################################
## This file reports the answers to all questions in a PsyToolkit questionnaire
## This is for getting a "quick" overview of your data
## The only function of this file that should used by end-users is psytkReport()
## Do not edit this file
## #############################################################################################

## internal function to make 00:00 or 00:00:00 for reporting duration of anwering questions

formatTime = function( ms ){
  totalSecs = ms / 1000
  h = totalSecs %/% 3600
  m = (totalSecs %% 3600) %/% 60
  s = floor(totalSecs %% 60)
  
  if (h > 0) {
    sprintf("%02d:%02d:%02d", h, m, s)
  } else {
    sprintf("%02d:%02d", m, s)
  }
}

## options
## textbox: show textbox reports (unless empty), also reports how many empty
## question (T/F): show the original question text

psytkReport = function( psytkSurveyData , textbox=FALSE , question = TRUE ){

    psytkSurvey = psytkSurveyData$surveyobject$overview
    psytkItems = psytkSurveyData$surveyobject$psytkItems

    if ( !is.null( psytkSurveyData$warnings  )){
        catn("There were warnings during the reading in the survey data.")
        catn("Make sure to consider this in your data analysis.")
        catn("Call psytkWarnings() to see the details.")
    }

    catn("Sample size: " , psytkSurveyData$n ,"\n")

    ## -- Report times used + min,max ----------------------------------------

    medTimes = apply( psytkSurveyData$times , 2 , median , na.rm = TRUE )
    minTimes = apply( psytkSurveyData$times , 2 , min , na.rm = TRUE )
    maxTimes = apply( psytkSurveyData$times , 2 , max , na.rm = TRUE )

    medTimes = sapply( medTimes , formatTime )
    minTimes = sapply( minTimes , formatTime )
    maxTimes = sapply( maxTimes , formatTime )

    allTimes = data.frame( label=colnames(psytkSurveyData$times) , medTimes,minTimes,maxTimes)

    catn("Answering speed in MM:SS or HH:MM:SS")
    catn("Questions combined on one screen are for the screen")

    psytkTable( allTimes , header=c("Label","Median","Shortest","Longest" ) )

    ## -- Check if CloudResearch demographics is coded -----------------------

    if ( "CRData" %in% names( psytkSurveyData ) ){
        catn("CloudResearch Demographic data are available:\n")
        tmpAge = as.numeric( psytkSurveyData$CRData$Age )
        catn("Age Range : ",reportRange( tmpAge ))
        catn("    Mean  : ",round( mean(tmpAge) ,digits=2))
        catn("    Median: ",round( median(tmpAge) ,digits=2))
        
        catn("Men       : ",sum( psytkSurveyData$CRData$Sex=="Male" )  , " ", round( sum( psytkSurveyData$CRData$Sex=="Male" ) / psytkSurveyData$n * 100 , digits = 0 ) , "%" )
        catn("Women     : ",sum( psytkSurveyData$CRData$Sex=="Female") , " ", round( sum( psytkSurveyData$CRData$Sex=="Female" ) / psytkSurveyData$n * 100 , digits = 0), "%" )
        catn("---------------------------------------------------")

        catn("counts/percentages race:\n")
        tmpCounts      = table( psytkSurveyData$CRData$Race )
        tmpPercentages = proportions( tmpCounts ) * 100
        print(cbind(tmpCounts,tmpPercentages))
        catn("------------------------------------------------\n\n")
    }

    ## -- Check if Prolific demographics is coded -----------------------

    if ( "PRData" %in% names( psytkSurveyData ) ){
        catn("\nProlific Demographic data are available:\n")
        tmpAge = as.numeric( psytkSurveyData$PRData$Age )
        catn("Age Range : ",reportRange( tmpAge ))
        catn("Age Mean  : ",round( mean(tmpAge) ,digits=2))
        catn("Age Median: ",round( median(tmpAge) ,digits=2))
        catn("")
        catn("Men       : ",sum( psytkSurveyData$PRData$Sex=="Male" )  , " ", round( sum( psytkSurveyData$PRData$Sex=="Male" ) / psytkSurveyData$n * 100 , digits = 0 ) , "%" )
        catn("Women     : ",sum( psytkSurveyData$PRData$Sex=="Female") , " ", round( sum( psytkSurveyData$PRData$Sex=="Female" ) / psytkSurveyData$n * 100 , digits = 0), "%" )

        catn("counts/percentages race:\n")
        tmpCounts      = table( psytkSurveyData$PRData$Ethnicity.simplified )
        tmpPercentages = proportions( tmpCounts ) * 100
        tmp = as.data.frame(cbind(tmpCounts,tmpPercentages))

        catn("------------------------------------------------\n\n")
    }

    ##--------------------------------------------------------------
    ## now go through questions

    for( i in 1:dim(psytkSurvey)[1] ){

        ## -- main title 

        # catn(paste("Label: ", psytkSurvey[ i ,"labels"] , " (" , psytkSurvey[ i ,"types"] , ") " , psytkSurvey[i,"notes"] ,sep="") ) ; hr()
        tmpType = psytkSurvey[ i ,"types"] 
        if ( tmpType == "radio" ){tmpType="multiple choice"}

        tmpLabel = format( psytkSurvey[ i ,"labels"] , width = 60 - length(psytkSurvey[ i ,"labels"]) , justify="centre" )

        tmpType = psytkSurvey[ i , "types" ] # extract type of question        
        content = data.frame( tmpLabel , format( tmpType , width = 15 - length(tmpType) , justify="centre" ))

        psytkTable( content , header = F )

        if ( question == T ){
            tmpQuestion = psytkSurvey$questions[i]
            if ( tmpQuestion != "" ){
                catn("Question: ", tmpQuestion )
            }
        }

        ## -- now report based on type -------------------------------------------------

        
        ## ##### -- radio --------------------------------------------------------------

        if ( tmpType == "radio" ){

            tmpLabel   = psytkSurvey[i,"labels"]
            tmpItems   = psytkItems[[ i ]]
            tmpScores = psytkSurveyData$radioScores[,tmpLabel]
            tmpN       = length(tmpScores)

            colNanswers    = rep(NA,length(tmpItems) )
            colPercentage = rep("",length(tmpItems) )
            
            for( j in 1:length(tmpItems)){
                colNanswers[j] = sum( tmpScores == j , na.rm=T)
                colPercentage[j]  = round0p( sum( tmpScores == j , na.rm=TRUE) , tmpN )
            }

            psytkTable( data.frame( tmpItems , colNanswers , colPercentage ) , header=c("Items","N","%"))
            catn()
        }

        ## ##### -- drop (essentially the same as radio) -------------------------------

        if ( tmpType == "drop" ){

            tmpLabel   = psytkSurvey[i,"labels"]
            tmpItems   = psytkItems[[ i ]]
            tmpScores = psytkSurveyData$dropScores[,tmpLabel]
            tmpN       = length(tmpScores)
            for( j in 1:length(tmpItems)){
                catn( "- ",tmpItems[j],"\t| n =",sum( tmpScores == j , na.rm=T) , "\t|" , round0p( sum( tmpScores == j , na.rm=TRUE) , tmpN ))
            }
            catn()
        }

        ## ##### -- check --------------------------------------------------------------

        if ( tmpType == "check" ){
            tmpLabel   = psytkSurvey[i,"labels"]
            tmpItems   = psytkItems[[ i ]]

            tmpPercentages = rep( NA , length(tmpItems) )

            for( j in 1:length(tmpItems) ){
                tmpN = sum( !is.na( psytkSurveyData$checkAnswers[,paste(tmpLabel,j,sep=".")] ) )
                tmpPercentages[j] = round0p( sum( psytkSurveyData$checkAnswers[,paste(tmpLabel, j ,sep=".") ] , na.rm=TRUE) , tmpN )
            }
            catn()
            psytkTable( data.frame( percentage=tmpPercentages , items=tmpItems ) )
        }

        ## ##### -- textline --------------------------------------------------------------

        if ( tmpType == "textline" ){

            tmpLabel   = psytkSurvey[i,"labels"]
            tmpItems   = psytkItems[[ i ]]

            if ( length( tmpItems ) == 1 ) {

                ## first check if the column contains strings or numbers (or mixed)
                if ( is.numeric ( psytkSurveyData$textlineAnswers[,tmpLabel] ) ){

                    if ( sum( !is.na( psytkSurveyData$textlineAnswers[,tmpLabel] ) ) > 0 ){
                        tmpcount  = sum( !is.na( psytkSurveyData$textlineAnswers[,tmpLabel] ) )
                        tmpperc   = paste( round( tmpcount / psytkSurveyData$n * 100 , digits = 1 ) , "%" , sep="" )
                        tmpmean   = mean(as.numeric(psytkSurveyData$textlineAnswers[,tmpLabel]),na.rm=T)
                        tmpmedian = median(as.numeric(psytkSurveyData$textlineAnswers[,tmpLabel]),na.rm=T)
                        
                        catn("Range : ",reportRange( as.numeric(psytkSurveyData$textlineAnswers[,tmpLabel] ) ))
                        catn("Mean  : ",round( tmpmean ,digits=2))
                        catn("Median: ",round( tmpmedian ,digits=2))
                        catn("N     : ",tmpcount,tmpperc,"answered")
                    }else{
                        catn("Nobody answered")
                    }
                    
                }else{ ## if textline contains strongs
                    catn("Unique Answers given:")

                    tmpAnswers = unique(dropNA( psytkSurveyData$textlineAnswers[,tmpLabel] ) )
                    tmpAnwers = tmpAnswers[ tmpAnswers != "" ]

                    for( tmpx in 1:length(tmpAnswers) ){ catn(tmpAnswers[tmpx] ) }
                }

            }else{

                for( j in 1:length(tmpItems) ){
                    tmpSubLabel = paste(tmpLabel,j,sep=".")

                    if ( is.numeric ( psytkSurveyData$textlineAnswers[,tmpSubLabel] ) ){

                        if ( sum( !is.na( psytkSurveyData$textlineAnswers[,tmpSubLabel] ) ) > 0 ){
                            tmpcount  = sum( !is.na( psytkSurveyData$textlineAnswers[,tmpSubLabel] ) )
                            tmpperc   = paste( round( tmpcount / psytkSurveyData$n * 100 , digits = 1 ) , "%" , sep="" )
                            tmpmean   = mean(as.numeric(psytkSurveyData$textlineAnswers[,tmpSubLabel]),na.rm=T)
                            tmpmedian = median(as.numeric(psytkSurveyData$textlineAnswers[,tmpSubLabel]),na.rm=T)
                            
                            catn("Range : ",reportRange( as.numeric(psytkSurveyData$textlineAnswers[,tmpSubLabel] ) ))
                            catn("Mean  : ",round( tmpmean ,digits=2))
                            catn("Median: ",round( tmpmedian ,digits=2))
                            catn("N     : ",tmpcount,tmpperc,"answered")
                        }else{
                            catn("Nobody answered")
                        }
                    }else{ ## if textlines contain strings

                        catn("Answers given:")
                        catn( paste( psytkSurveyData$textlineAnswers[,tmpSubLabel] ) )
                    }
                }
            }
            catn()
        }

        ## ##### -- textbox --------------------------------------------------------------

        if ( tmpType == "textbox" & textbox ){

            tmpLabel   = psytkSurvey[i,"labels"]
            tmpItems   = psytkItems[[ i ]]
            if ( length(tmpItems) > 1 ){
                for( j in 1:length(tmpItems) ){
                    for( k in 1:psytkSurveyData$n ){
                        catn( "| " , psytkSurveyData$textboxAnswers[ j , paste( tmpLabel , k , sep = "." ) ] )
                    }
                }
            }
            catn()
        }

        ## ##### -- rank --------------------------------------------------------------

        if ( tmpType == "rank" ){

            tmpLabel   = psytkSurvey[i,"labels"]
            tmpItems   = psytkItems[[ i ]]
            tmpPercentages = rep( NA , length(tmpItems) ) ## these are actually not percentages, need to rename variable

            for( j in 1:length(tmpItems) ){
                tmpN = sum( !is.na( psytkSurveyData$rankAnswers[,paste(tmpLabel, j ,sep=".")] ) )
                tmpPercentages[j] = sprintf("%.2f",round(mean( psytkSurveyData$rankAnswers[,paste(tmpLabel, j ,sep=".")] ),digits=2))
            }
            catn()

            psytkTable( data.frame( position=tmpPercentages , items=tmpItems ) )
        }

        ## ##### -- range --------------------------------------------------------------

        if ( tmpType == "range" ){

            tmpLabel   = psytkSurvey[i,"labels"]
            tmpItems   = psytkItems[[ i ]]
            tmpScores  = rep( NA , length( tmpItems ) )

            for( j in 1:length(tmpItems) ){
                tmpN = sum( !is.na( psytkSurveyData$rangeAnswers[,paste(tmpLabel,j,sep=".")] ) )
                tmpScores[j] = sprintf("%.2f",round( mean( psytkSurveyData$rangeAnswers[,paste(tmpLabel,j,sep=".")] ) , digits = 2 ))
            }
            catn()

            psytkTable( data.frame( mean=tmpScores , items=tmpItems ) )
        }

        ## ##### -- set --------------------------------------------------------------

        if ( tmpType == "set" ){
            
            tmpLabel   = psytkSurvey[i,"labels"]
            tmpScores = psytkSurveyData$setScores[,tmpLabel]
            tmpN       = sum(!is.na(tmpScores))
            catn( "n =",tmpN , "\t| mean = " , round( mean( tmpScores ) ,digits=2) , 
                 "\t| median = " , median( tmpScores ) , 
                 "\t| range = " , reportRange( tmpScores ) )
            catn()

        }

        ## ##### -- scale --------------------------------------------------------------

        if ( tmpType == "scale" ){
            tmpLabel   = psytkSurvey[ i , "labels" ]
            tmpItems   = psytkItems[[ i ]]

            df = NULL # start with data frame

            if ( length( tmpItems ) == 1 ){ # for these, we do not use the dots in the scaleScores
                tmpScore = sprintf("%.2f",round( mean( psytkSurveyData$scaleScores[,tmpLabel ] , na.rm=T ) , digits = 2 ))
                catn(tmpScore,"\t|",tmpItems[1] )
                df = rbind( df , c(tmpScore,tmpItems[1] ))
            }else{ # if there is more than one item (which is the typical use)
                for( j in 1:length(tmpItems) ){
                    tmpScore = sprintf("%.2f",round( mean( psytkSurveyData$scaleScores[,paste(tmpLabel,j,sep=".")] , na.rm = TRUE) , digits = 2 ))
                    df = rbind( df , c(tmpScore,tmpItems[j] ))
                }
            }

            colnames(df)=c("Mean score","Item")

            psytkTable(df)

            catn()
        }
    } # end of for loop through all survey questionnaire items
}

## this simply gives you a list of all labels and questions

psytkQ = function( data ){ data$surveyobject$overview }

psytkWarnings = function( data ){

    if( length(data$warnings) > 0 ){

        catn("Number of warnings: ",length(data$warnings))

        for( i in 1:length(data$warnings) ){
            catn( i , ": ", data$warnings[i] )
        }
    }else{
        catn("There were no warnings.")
    }

}
