% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcStates.R
\name{mcStates}
\alias{mcStates}
\title{Access Markov Chain States in the MACRAME Algorithm}
\usage{
mcStates(object)
}
\arguments{
\item{object}{An object of the class \code{profileLadder} returned from the function
\code{mcReserve()} or an object of the class \code{mcSetup} returned from the
function \code{incrExplor()}.}
}
\value{
The vector of the Markov chain states that are used by the MACRAME algorithm.
}
\description{
Retrieves the Markov chain components from a \code{profileLadder} object returned
from the function \code{mcReserve()} or the \code{mcSetup} object returned
from the function \code{incrExplor()}. In particular, the function returns
the vector of the states used by the underlying Markov Chain utilized for
reserve prediction in the MACRAME algorithm.
}
\examples{
## MACRAME reserve prediction with the DEFAULT Markov chain setup 
output <- mcReserve(CameronMutual)

## Extracting the corresponding Markov states
mcStates(output)

#' ## Extracting the corresponding states when explicit breaks are used
mcStates(mcReserve(CameronMutual, breaks = c(1000, 2000, 3000)))

}
\seealso{
\code{\link[=mcReserve]{mcReserve()}}, \code{\link[=incrExplor]{incrExplor()}}, \code{\link[=mcBreaks]{mcBreaks()}}, \code{\link[=mcTrans]{mcTrans()}}
}
