% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcStates.R
\name{mcStates}
\alias{mcStates}
\title{Access Markov Chain States in the MACRAME Algorithm}
\usage{
mcStates(object)
}
\arguments{
\item{object}{An object of class \code{profileLadder}.}
}
\value{
The vector of the Markov chain states that are used by the MACRAME algorithm.
}
\description{
Retrieves the Markov chain components from a \code{profileLadder} object returned
from the function \code{mcReserve()} -- in particular, the function returns
the vector of states used by the underlying Markov Chain utilized in the MACRAME
reserve prediction.
}
\examples{
## MACRAME reserve prediction with the DEFAULT Markov chain setup 
output <- mcReserve(CameronMutual)

## Extracting the corresponding break points
mcStates(output)

}
\seealso{
\code{\link[=mcReserve]{mcReserve()}}, \code{\link[=mcBreaks]{mcBreaks()}}, \code{\link[=mcTrans]{mcTrans()}}
}
