% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_functions.R
\name{makeCalibrationModel}
\alias{makeCalibrationModel}
\title{(internal) construct a model}
\usage{
makeCalibrationModel(d, dimensions, bound_cov)
}
\arguments{
\item{d}{a \code{\linkS4class{PROsetta_data}} object.}

\item{dimensions}{the number of dimensions to use in the model. Must be \code{1} or \code{2}.
If \code{1}, all instruments are modeled to be from one dimension.
If \code{2}, each instrument is modeled to be from its own dimension (i.e., calibrated projection is used).}

\item{bound_cov}{only used when \code{dimensions} is \code{2}.
If \code{TRUE}, then constrain the between-dimension covariance to be \code{< .999}.}
}
\value{
\code{\link{makeCalibrationModel}} returns a \code{\link[mirt]{mirt.model}} object.
}
\description{
\code{\link{makeCalibrationModel}} is an internal function for constructing a model.
}
\examples{
PROsetta:::makeCalibrationModel(data_asq, 1, FALSE)
PROsetta:::makeCalibrationModel(data_asq, 1, TRUE)
PROsetta:::makeCalibrationModel(data_asq, 2, FALSE)
PROsetta:::makeCalibrationModel(data_asq, 2, TRUE)

}
\keyword{internal}
