% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Olink_bridgeselector.R
\name{olink_bridgeselector}
\alias{olink_bridgeselector}
\title{Bridge selection function}
\usage{
olink_bridgeselector(df, sampleMissingFreq, n)
}
\arguments{
\item{df}{Tibble/data frame in long format such as produced by the Olink Analyze read_NPX function.}

\item{sampleMissingFreq}{The threshold for sample wise missingness.}

\item{n}{Number of bridge samples to be selected.}
}
\value{
A "tibble" with sample IDs and mean NPX for a defined number of bridging samples. Columns include:

\itemize{
\item{SampleID:} Sample ID
\item{PercAssaysBelowLOD:} Percent of Assays that are below LOD for the sample
\item{MeanNPX:} Mean NPX for the sample
}
}
\description{
The bridge selection function will select a number of bridge samples based on the input data. It selects samples with
good detection, which passes QC and cover a good range of the data.
}
\details{
When running the selector, the \code{sampleMissingFreq} value
represents a maximum percentage of data below LOD allowed per
sample. When running plasma on smaller panels, such as Target
96, \code{sampleMissingFreq = 0.10} can be a good starting point.
Larger panels such as Explore HT have many proteins that are
only expressed in certain diseases or matrices and therefore
more data below LOD is expected. In this case
\code{sampleMissingFreq = 0.5} can be a good starting point.

For more information, please consult the Introduction to
Bridging tutorial. \cr\cr
The function accepts NPX Excel files with data < LOD replaced.
}
\examples{
\donttest{bridge_samples <- olink_bridgeselector(npx_data1, sampleMissingFreq = 0.1, n = 20)}
}
