% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DatabasePrep.R
\name{DatabasePrep}
\alias{DatabasePrep}
\title{Gather data of several countries in a list. Particularly useful for GVAR-based setups (Compute "GVARFactors")}
\usage{
DatabasePrep(
  t_First,
  t_Last,
  Economies,
  N,
  FactorLabels,
  ModelType,
  Wgvar = NULL,
  DataPathMacro = NULL,
  DataPathYields = NULL
)
}
\arguments{
\item{t_First}{Start date of the sample period in the format yyyy-mm-dd.}

\item{t_Last}{End date of the sample period in the format yyyy-mm-dd.}

\item{Economies}{A character vector containing the names of the economies included in the system.}

\item{N}{Integer. Number of country-specific spanned factors.}

\item{FactorLabels}{A list of character vectors with labels for all variables in the model.}

\item{ModelType}{A character vector indicating the model type to be estimated.}

\item{Wgvar}{GVAR transition matrix of size C x C, applicable if a GVAR-type model is selected. Default is NULL.}

\item{DataPathMacro}{File path to the Excel file containing macroeconomic data, if provided. The default path points to the Excel file available within the package.}

\item{DataPathYields}{File path to the Excel file containing yields data, if provided. The default path points to the Excel file available within the package}
}
\value{
List containing the risk factor set used in the estimation of the GVAR-based models
}
\description{
Gather data of several countries in a list. Particularly useful for GVAR-based setups (Compute "GVARFactors")
}
\examples{
DomVar <- c("Eco_Act", "Inflation")
GlobalVar <- c("GBC", "CPI_OECD")
t0 <- "2006-09-01"
tF <-  "2019-01-01"
Economies <- c("China", "Brazil", "Mexico", "Uruguay", "Russia")
N <- 3
ModelType <- "GVAR multi"
FactorLabels <-  LabFac(N, DomVar, GlobalVar, Economies, ModelType)
Wgvar <- Transition_Matrix(t_First = "2006", t_Last= "2019", Economies, type = "Sample Mean")


GVARFactors <- DatabasePrep(t0, tF, Economies, N, FactorLabels, ModelType, Wgvar)


}
