% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MTAFT_test.R
\name{MTAFT_test}
\alias{MTAFT_test}
\title{Perform score-type test for the presence of threshold effect in multi-threshold situations.}
\usage{
MTAFT_test(Y, X, Tq, delta, nboots)
}
\arguments{
\item{Y}{Response variable.}

\item{X}{Covariates.}

\item{Tq}{Threshold variable.}

\item{delta}{Indicator vector for censoring.}

\item{nboots}{Number of bootstrap iterations.}
}
\value{
p-value result indicating the presence of threshold effect.
}
\description{
This function performs a score-type test statistics for the presence of threshold effect in multi-threshold situations.
}
\examples{
\donttest{
# Generate simulated data with 500 samples and normal error distribution
dataset <- MTAFT_simdata(n = 500, err = "normal")
Y <- dataset[, 1]
delta <- dataset[, 2]
Tq <- dataset[, 3]
X <- dataset[, -c(1:3)]

# Perform score-type test with 500 bootstraps
pval <- MTAFT_test(Y, X, Tq, delta, nboots = 500)

# Perform score-type test with 1000 bootstraps
pval <- MTAFT_test(Y, X, Tq, delta, nboots = 1000)
}
}
