% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcee_helper_nuisance_config.R
\name{mcee_config_rf}
\alias{mcee_config_rf}
\title{Configure Random Forest for MCEE nuisance parameters}
\usage{
mcee_config_rf(target, formula)
}
\arguments{
\item{target}{Character. Nuisance parameter name ("p", "q", "eta", "mu", "nu").}

\item{formula}{RHS-only formula (e.g., \code{~ X1 + X2 + dp}).}
}
\value{
A configuration list for use with \code{\link{mcee_general}}.
}
\description{
Creates a configuration to fit nuisance parameters using random forests
via \code{randomForest::randomForest()}. Good for nonlinear patterns.
}
\examples{
# Random forest for complex propensity model
cfg_q <- mcee_config_rf("q", ~ dp + M + X1 + X2)
}
