% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcee_helper_nuisance_config.R
\name{mcee_config_maker}
\alias{mcee_config_maker}
\title{Build a nuisance-configuration object for \code{mcee_general()}}
\usage{
mcee_config_maker(
  target,
  method = NULL,
  formula = NULL,
  family = NULL,
  known = NULL,
  known_a1 = NULL,
  known_a0 = NULL,
  clipping = NULL,
  SL.library = NULL,
  ...
)
}
\arguments{
\item{target}{Character; which nuisance to configure. One of
\code{"p"}, \code{"q"}, \code{"eta"}, \code{"mu"}, \code{"nu"}.}

\item{method}{Optional character learner name when *not* using known values.
Supported:\cr
\itemize{
  \item \code{"glm"}, \code{"gam"}, \code{"lm"} (formula-based);
  \item \code{"rf"} (randomForest), \code{"ranger"};
  \item \code{"sl"} (SuperLearner).
}
Ignored if any of \code{known}, \code{known_a1}, \code{known_a0} is provided.}

\item{formula}{RHS-only formula describing predictors for the learner
(used when \code{method} is formula-based; ignored for \code{known}).
For \code{method = "gam"}, \code{s()} terms are allowed (via \pkg{mgcv}).}

\item{family}{Optional GLM/GAM family. If \code{NULL}, a default is chosen
based on \code{target} and \code{method} (typically \code{binomial()}
for \code{p}/\code{q}, \code{gaussian()} for \code{eta}/\code{mu}/\code{nu}).}

\item{known}{Optional numeric scalar/vector of **known values** for the nuisance.
Commonly used for \code{target = "p"} in MRTs when the randomization
probability is known.}

\item{known_a1, known_a0}{Optional numeric scalar/vector providing known values
for the \emph{treatment-specific} versions of a nuisance (e.g., \code{eta1}/\code{eta0},
\code{mu1}/\code{mu0}, \code{nu1}/\code{nu0}). If supplied, the function
returns a "known" config and \code{method}/\code{formula}/\code{family} are ignored.}

\item{clipping}{Optional numeric vector of length 2, \code{c(lower, upper)},
to truncate predictions (e.g., probabilities into \eqn{[\epsilon, 1-\epsilon]}).
Validated but not required.}

\item{SL.library}{Character vector of SuperLearner libraries (only used
when \code{method = "sl"}). If \code{NULL}, defaults to
\code{c("SL.mean", "SL.glm", "SL.gam")}.}

\item{...}{Reserved for future extensions; currently ignored.}
}
\value{
A named \code{list} describing the configuration. For known configs:
\preformatted{
list(
  nuisance_parameter = <target>,
  known   = <numeric or NULL>,
  known_a1 = <numeric or NULL>,
  known_a0 = <numeric or NULL>,
  clipping = <numeric length-2 or NULL>
)
}
For learner configs:
\preformatted{
list(
  nuisance_parameter = <target>,
  method  = <character>,
  formula = <formula or NULL>,
  family  = <family or NULL>,
  clipping = <numeric length-2 or NULL>,
  SL.library = <character vector; only when method == "sl">
)
}
}
\description{
Creates a configuration list describing **how to obtain a nuisance function**
used by \code{\link{mcee_general}}. You may either:
\enumerate{
  \item supply **known values** (bypasses learning), or
  \item specify a **learning method** (e.g., GLM/GAM/RF/Ranger/SL) with a formula.
}
}
\details{
If any of \code{known}, \code{known_a1}, or \code{known_a0} is provided,
the returned configuration is of type “known” and **no learner will be fit**.
Otherwise, the configuration records the requested learner, formula, family,
optional clipping, and (for SL) the library.

Internally, helper validators ensure \code{method} is supported and
\code{clipping} (if provided) is sane. Family defaults are chosen when
\code{family = NULL} for GLM/GAM methods.
}
\examples{
# Known p (MRT randomization), GLM for other nuisances
cfg_p <- mcee_config_maker("p", known = 0.5)
cfg_q <- mcee_config_maker("q", method = "glm", formula = ~ dp + M)
cfg_eta <- mcee_config_maker("eta", method = "glm", formula = ~dp)
cfg_mu <- mcee_config_maker("mu", method = "glm", formula = ~ dp + M)
cfg_nu <- mcee_config_maker("nu", method = "glm", formula = ~dp)

# SuperLearner with default library (set explicitly if you prefer)
# cfg_q_sl <- mcee_config_maker("q", method = "sl", formula = ~ dp + M,
#                               SL.library = c("SL.mean","SL.glm","SL.ranger"))

# Known treatment-specific outcome regressions (e.g., from external source)
# cfg_eta_known <- mcee_config_maker("eta", known_a1 = rep(1, 100),
#                                         known_a0 = rep(0, 100))

}
\seealso{
\code{\link{mcee_general}},
helper constructors like
\code{mcee_config_known()},
\code{mcee_config_glm()},
\code{mcee_config_gam()},
\code{mcee_config_lm()},
\code{mcee_config_rf()},
\code{mcee_config_ranger()},
\code{mcee_config_sl()},
\code{mcee_config_sl_user()}.
}
