% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoxMM.R
\name{CoxMM}
\alias{CoxMM}
\title{MM algorithm based on AD technology for Cox model}
\usage{
CoxMM(formula, data, beta = NULL, Maxiter = 2000, convergence = 1e-06, ...)
}
\arguments{
\item{formula}{A formula object, which contains on the left hand side an object of the type \code{Surv}
and on the right hand side is the terms, e.g. \code{formula=Surv(time, status) ~ x}.}

\item{data}{A \code{data.frame} in which to interpret the variables named in the formula.}

\item{beta}{A vector of unknown regression parameters, default is \code{NULL}.
If is \code{NULL}, then make all \code{beta=0} during calculation.}

\item{Maxiter}{The maximum number of iterations is specified by default as 2000.}

\item{convergence}{Specify the convergence criterion, the default is 1e-6.}

\item{...}{Additional arguments}
}
\value{
An object of class \code{CoxMM} that contains the following fields: the Time, total amount of observations,
total number of failure events, the variable name, the \eqn{\beta}, the \eqn{\lambda}, the \eqn{\Lambda}, convergence result,
the log likelihood value, the standard deviation of the estimated \eqn{\beta}, the likelihood-based 95\% confidence interval for the \eqn{\beta}.
}
\description{
Let \eqn{T_i, C_i} and \eqn{X_i = (x_{i1},\cdots, x_{iq})^T} denote the,
survival time, the censoring time and a \eqn{q} dimension vector of coefficients for the \eqn{i}-th individual, respectively. And assume the censoring time
\eqn{C_i} is independent of the survival time \eqn{T_i} are mutually independent, and \eqn{I_i = I(T_{i} \leqslant C_{i})} is the censoring indicator.
Then the instantaneous hazard rate function of \eqn{T_i} is

\deqn{\lambda(t|X_i)=\lambda_{0}(t) \exp(X_{i}^{T} \beta)}

where \eqn{\lambda_{0}(.)} is a baseline hazard rate and \eqn{\beta = (\beta_1, \cdots, \beta_q)^{T}} is a vector of regression parameters.
We denote \eqn{\Lambda} as the accumulative hazard rate. Then the observed data likelihood function is

\deqn{ L(\alpha | Y_{obs}) = \prod_{i=1}^n (\lambda_{0}(t_i) \exp(X_{i}^{T} \beta))^{I_i} \exp(-\Lambda(t_i) \exp(X_{i}^{T} \beta)) }

where \eqn{\alpha = (\beta, \Lambda)}. The \code{CoxMM} function is used to calculate the Cox model.
}
\details{
The \code{CoxMM} function is used to calculate the Cox model using MM algorithms
based on AD technology. EM algorithms rely on the fact that, after profiling out the nonparametric component \eqn{\Lambda},
the resulting function is concave. However, when this assumption does not hold, maximizing the resulting function using Newton’s method becomes difficult,
especially when there are a large number of covariates. MM algorithms can avoid the
concavity requirement and bypass the need for Newton method and matrix inversion.
}
\examples{
library(survival)
CoxMM(Surv(time, status) ~ age + sex, lung)

}
\references{
D.R. Cox.(1972). 'Regression models and life tables.' \emph{Journal of the Royal Statistical Society(Series B)} \strong{34}(2), 187-220.

Zhang L.L. and Huang X.F.(2022). 'On MM algorithms for Cox model with right-censored data.' \emph{In International Conference on Cloud Computing, Internet of Things, and Computer Applications (CICA 2022)} \strong{12303}, 29-38.
}
