% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_data.R
\name{force_mic}
\alias{force_mic}
\title{Force MIC-like into MIC-compatible format}
\usage{
force_mic(
  value,
  levels_from_AMR = FALSE,
  max_conc = 512,
  min_conc = 0.002,
  method = "closest",
  prefer = "max"
)
}
\arguments{
\item{value}{vector of MIC-like values (numeric or character)}

\item{levels_from_AMR}{conform to AMR::as.mic levels}

\item{max_conc}{maximum concentration to force to}

\item{min_conc}{minimum concentration to force to}

\item{method}{method to use when forcing MICs (closest or round_up)}

\item{prefer}{where value is in between MIC (e.g., 24mg/L) chose the higher
MIC ("max") or lower MIC ("min"); only applies to method = "closest"}
}
\value{
AMR::as.mic compatible character
}
\description{
Convert a value that is "almost" an MIC into a valid MIC value.
}
\details{
Some experimental or analytical conditions measure MIC (or surrogate) in a
way that does not fully conform to traditional MIC levels
(i.e., concentrations). This function allows these values to be coerced into
an MIC value that is compatible with the AMR::mic class. When using method =
"closest", the function will choose the closest MIC value to the input value
(e.g., 2.45 will be coerced to 2). When using method = "round up", the
function will round up to the next highest MIC value (e.g., 2.45 will be
coerced to 4). "Round up" is technically the correct approach if the input
value was generated from an experiment that censored between concentrations
(e.g., broth or agar dilution). However, "closest" may be more appropriate in
some cases.
}
\examples{
force_mic(c("2.32", "<4.12", ">1.01"))
}
